/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsFileStatusHdfs {
    static final String testfilename = "/tmp/testFileStatusSerialziation";
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static Configuration CONF;
    private static FileSystem fHdfs;

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem();
        defaultWorkingDirectory = fHdfs.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fHdfs.mkdirs(defaultWorkingDirectory);
    }

    @Test
    public void testFileStatusSerialziation() throws IOException, URISyntaxException {
        long len = FileSystemTestHelper.createFile((FileSystem)fHdfs, (String)testfilename);
        Configuration conf = ViewFileSystemTestSetup.createConfig();
        ConfigUtil.addLink((Configuration)conf, (String)"/tmp", (URI)new URI(fHdfs.getUri().toString() + "/tmp"));
        FileSystem vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus stat = vfs.getFileStatus(new Path(testfilename));
        Assert.assertEquals((long)len, (long)stat.getLen());
        DataOutputBuffer dob = new DataOutputBuffer();
        stat.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        FileStatus deSer = new FileStatus();
        deSer.readFields((DataInput)dib);
        Assert.assertEquals((long)len, (long)deSer.getLen());
    }

    @AfterClass
    public static void cleanup() throws IOException {
        fHdfs.delete(new Path(testfilename), true);
    }

    static {
        CONF = new Configuration();
    }
}

