/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestUrlStreamHandler
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDfsUrls() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        FsUrlStreamHandlerFactory factory = new FsUrlStreamHandlerFactory();
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)factory);
        Path filePath = new Path("/thefile");
        try {
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(filePath);
            os.write(fileContent);
            os.close();
            URI uri = fs.getUri();
            URL fileURL = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), filePath.toString());
            InputStream is = fileURL.openStream();
            TestUrlStreamHandler.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            TestUrlStreamHandler.assertEquals((int)1024, (int)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                TestUrlStreamHandler.assertEquals((byte)fileContent[i], (byte)bytes[i]);
            }
            fs.delete(filePath, false);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileUrls() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File tmpDir = new File(conf.get("hadoop.tmp.dir"));
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + tmpDir);
        }
        File tmpFile = new File(tmpDir, "thefile");
        URI uri = tmpFile.toURI();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        try {
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(new Path(uri.getPath()));
            os.write(fileContent);
            os.close();
            URL fileURL = uri.toURL();
            InputStream is = fileURL.openStream();
            TestUrlStreamHandler.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            TestUrlStreamHandler.assertEquals((int)1024, (int)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                TestUrlStreamHandler.assertEquals((byte)fileContent[i], (byte)bytes[i]);
            }
            fs.delete(new Path(uri.getPath()), false);
        }
        finally {
            fs.close();
        }
    }
}

