/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import org.apache.hadoop.cli.CLITestHelperDFS;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHDFSCLI
extends CLITestHelperDFS {
    protected MiniDFSCluster dfsCluster = null;
    protected FileSystem fs = null;
    protected String namenode = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf.setClass("hadoop.security.authorization.policyprovider", HDFSPolicyProvider.class, PolicyProvider.class);
        this.conf.setInt("dfs.replication", 1);
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2", "/rack2", "/rack3", "/rack4", "/rack4"};
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6", "host7", "host8"};
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(8).racks(racks).hosts(hosts).build();
        this.dfsCluster.waitClusterUp();
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.username = System.getProperty("user.name");
        this.fs = this.dfsCluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + this.fs.getUri()), (boolean)(this.fs instanceof DistributedFileSystem));
    }

    protected String getTestFile() {
        return "testHDFSConf.xml";
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.fs) {
            this.fs.close();
        }
        this.dfsCluster.shutdown();
        Thread.sleep(2000L);
        super.tearDown();
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", this.namenode);
        expCmd = super.expandCommand(expCmd);
        return expCmd;
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor(this.namenode).executeCommand(cmd.getCmd());
    }

    @Test
    public void testAll() {
        super.testAll();
    }
}

