/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.HasFileDescriptor;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FSDataInputStream
extends DataInputStream
implements Seekable,
PositionedReadable,
Closeable,
ByteBufferReadable,
HasFileDescriptor,
CanSetDropBehind,
CanSetReadahead {
    public FSDataInputStream(InputStream in) throws IOException {
        super(in);
        if (!(in instanceof Seekable) || !(in instanceof PositionedReadable)) {
            throw new IllegalArgumentException("In is not an instance of Seekable or PositionedReadable");
        }
    }

    @Override
    public synchronized void seek(long desired) throws IOException {
        ((Seekable)((Object)this.in)).seek(desired);
    }

    @Override
    public long getPos() throws IOException {
        return ((Seekable)((Object)this.in)).getPos();
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return ((PositionedReadable)((Object)this.in)).read(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        ((PositionedReadable)((Object)this.in)).readFully(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        ((PositionedReadable)((Object)this.in)).readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return ((Seekable)((Object)this.in)).seekToNewSource(targetPos);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public InputStream getWrappedStream() {
        return this.in;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        if (this.in instanceof ByteBufferReadable) {
            return ((ByteBufferReadable)((Object)this.in)).read(buf);
        }
        throw new UnsupportedOperationException("Byte-buffer read unsupported by input stream");
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        if (this.in instanceof HasFileDescriptor) {
            return ((HasFileDescriptor)((Object)this.in)).getFileDescriptor();
        }
        if (this.in instanceof FileInputStream) {
            return ((FileInputStream)this.in).getFD();
        }
        return null;
    }

    @Override
    public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetReadahead)((Object)this.in)).setReadahead(readahead);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("this stream does not support setting the readahead caching strategy.");
        }
    }

    @Override
    public void setDropBehind(Boolean dropBehind) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetDropBehind)((Object)this.in)).setDropBehind(dropBehind);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("this stream does not support setting the drop-behind caching setting.");
        }
    }
}

