/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.util.ProtoUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestProtoUtil {
    private static final int[] TEST_VINT_VALUES = new int[]{0, 1, -1, 127, 128, 129, 255, 256, 257, 4660, -4660, 1193046, -1193046, 305419896, -305419896};

    @Test
    public void testVarInt() throws IOException {
        for (int value : TEST_VINT_VALUES) {
            this.doVarIntTest(value);
        }
        for (int i = 1; i != 0; i <<= 1) {
            this.doVarIntTest(i);
            this.doVarIntTest(-i);
            this.doVarIntTest(i - 1);
            this.doVarIntTest(~i);
        }
    }

    private void doVarIntTest(int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream cout = CodedOutputStream.newInstance((OutputStream)baos);
        cout.writeRawVarint32(value);
        cout.flush();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertEquals((long)value, (long)ProtoUtil.readRawVarint32((DataInput)dis));
    }
}

