/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;

public class TestGenericOptionsParser
extends TestCase {
    File testDir;
    Configuration conf;
    FileSystem localFs;

    public void testFilesOption() throws Exception {
        File tmpFile = new File(this.testDir, "tmpfile");
        Path tmpPath = new Path(tmpFile.toString());
        this.localFs.create(tmpPath);
        String[] args = new String[]{"-files", tmpFile.toString()};
        new GenericOptionsParser(this.conf, args);
        String files = this.conf.get("tmpfiles");
        TestGenericOptionsParser.assertNotNull((String)"files is null", (Object)files);
        TestGenericOptionsParser.assertEquals((String)"files option does not match", (String)this.localFs.makeQualified(tmpPath).toString(), (String)files);
        Configuration conf1 = new Configuration();
        URI tmpURI = new URI(tmpFile.toString() + "#link");
        args[0] = "-files";
        args[1] = tmpURI.toString();
        new GenericOptionsParser(conf1, args);
        files = conf1.get("tmpfiles");
        TestGenericOptionsParser.assertNotNull((String)"files is null", (Object)files);
        TestGenericOptionsParser.assertEquals((String)"files option does not match", (String)this.localFs.makeQualified(new Path(tmpURI)).toString(), (String)files);
        Configuration conf2 = new Configuration();
        args[0] = "-files";
        args[1] = "file:///xyz.txt";
        Exception th = null;
        try {
            new GenericOptionsParser(conf2, args);
        }
        catch (Exception e) {
            th = e;
        }
        TestGenericOptionsParser.assertNotNull((String)"throwable is null", (Object)th);
        TestGenericOptionsParser.assertTrue((String)"FileNotFoundException is not thrown", (boolean)(th instanceof FileNotFoundException));
        files = conf2.get("tmpfiles");
        TestGenericOptionsParser.assertNull((String)"files is not null", (Object)files);
    }

    public void testCreateWithOptions() throws Exception {
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A new option");
        Option opt = OptionBuilder.create((String)"newOpt");
        Options opts = new Options();
        opts.addOption(opt);
        String[] args = new String[]{"--newOpt", "7"};
        GenericOptionsParser g = new GenericOptionsParser(opts, args);
        TestGenericOptionsParser.assertEquals((String)"New option was ignored", (String)"7", (String)g.getCommandLine().getOptionValues("newOpt")[0]);
    }

    public void testConfWithMultipleOpts() throws Exception {
        String[] args = new String[]{"--conf=foo", "--conf=bar"};
        GenericOptionsParser g = new GenericOptionsParser(args);
        TestGenericOptionsParser.assertEquals((String)"1st conf param is incorrect", (String)"foo", (String)g.getCommandLine().getOptionValues("conf")[0]);
        TestGenericOptionsParser.assertEquals((String)"2st conf param is incorrect", (String)"bar", (String)g.getCommandLine().getOptionValues("conf")[1]);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new Configuration();
        this.localFs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new File(System.getProperty("test.build.data", "/tmp"), "generic");
        if (this.testDir.exists()) {
            this.localFs.delete(new Path(this.testDir.toString()), true);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.testDir.exists()) {
            this.localFs.delete(new Path(this.testDir.toString()), true);
        }
    }

    public void testTokenCacheOption() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        File tmpFile = new File(this.testDir, "tokenCacheFile");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        String[] args = new String[]{"-tokenCacheFile", tmpFile.toString()};
        Exception th = null;
        try {
            new GenericOptionsParser(this.conf, args);
        }
        catch (Exception e) {
            th = e;
        }
        TestGenericOptionsParser.assertNotNull((Object)th);
        TestGenericOptionsParser.assertTrue((String)"FileNotFoundException is not thrown", (boolean)(th instanceof FileNotFoundException));
        Path tmpPath = new Path(tmpFile.toString());
        localFs.create(tmpPath);
        new GenericOptionsParser(this.conf, args);
        String fileName = this.conf.get("mapreduce.job.credentials.json");
        TestGenericOptionsParser.assertNotNull((String)"files is null", (Object)fileName);
        TestGenericOptionsParser.assertEquals((String)"files option does not match", (String)localFs.makeQualified(tmpPath).toString(), (String)fileName);
        localFs.delete(new Path(this.testDir.getAbsolutePath()), true);
    }
}

