/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestMultithreadedTestUtil {
    private static final String FAIL_MSG = "Inner thread fails an assert";

    @Test
    public void testNoErrors() throws Exception {
        final AtomicInteger threadsRun = new AtomicInteger();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 3; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    threadsRun.incrementAndGet();
                }
            });
        }
        Assert.assertEquals((long)0L, (long)threadsRun.get());
        ctx.startThreads();
        long st = System.currentTimeMillis();
        ctx.waitFor(30000L);
        long et = System.currentTimeMillis();
        Assert.assertEquals((long)3L, (long)threadsRun.get());
        Assert.assertTrue((String)("Test took " + (et - st) + "ms"), (et - st < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testThreadFails() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

            @Override
            public void doWork() throws Exception {
                Assert.fail((String)TestMultithreadedTestUtil.FAIL_MSG);
            }
        });
        ctx.startThreads();
        long st = System.currentTimeMillis();
        try {
            ctx.waitFor(30000L);
            Assert.fail((String)"waitFor did not throw");
        }
        catch (RuntimeException rte) {
            Assert.assertEquals((Object)FAIL_MSG, (Object)rte.getCause().getMessage());
        }
        long et = System.currentTimeMillis();
        Assert.assertTrue((String)("Test took " + (et - st) + "ms"), (et - st < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testThreadThrowsCheckedException() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

            @Override
            public void doWork() throws Exception {
                throw new IOException("my ioe");
            }
        });
        ctx.startThreads();
        long st = System.currentTimeMillis();
        try {
            ctx.waitFor(30000L);
            Assert.fail((String)"waitFor did not throw");
        }
        catch (RuntimeException rte) {
            Assert.assertEquals((Object)"my ioe", (Object)rte.getCause().getMessage());
        }
        long et = System.currentTimeMillis();
        Assert.assertTrue((String)("Test took " + (et - st) + "ms"), (et - st < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testRepeatingThread() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

            @Override
            public void doAnAction() throws Exception {
                counter.incrementAndGet();
            }
        });
        ctx.startThreads();
        long st = System.currentTimeMillis();
        ctx.waitFor(3000L);
        ctx.stop();
        long et = System.currentTimeMillis();
        long elapsed = et - st;
        Assert.assertTrue((String)("Test took " + (et - st) + "ms"), (Math.abs(elapsed - 3000L) < 500L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Counter value = " + counter.get()), (counter.get() > 1000 ? 1 : 0) != 0);
    }
}

