/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MultithreadedTestUtil {
    public static final Log LOG = LogFactory.getLog(MultithreadedTestUtil.class);

    public static abstract class RepeatingTestThread
    extends TestingThread {
        public RepeatingTestThread(TestContext ctx) {
            super(ctx);
        }

        @Override
        public final void doWork() throws Exception {
            while (this.ctx.shouldRun() && !this.stopped) {
                this.doAnAction();
            }
        }

        public abstract void doAnAction() throws Exception;
    }

    public static abstract class TestingThread
    extends Thread {
        protected final TestContext ctx;
        protected boolean stopped;

        public TestingThread(TestContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (Throwable t) {
                this.ctx.threadFailed(t);
            }
            this.ctx.threadDone(this);
        }

        public abstract void doWork() throws Exception;

        protected void stopTestThread() {
            this.stopped = true;
        }
    }

    public static class TestContext {
        private Throwable err = null;
        private boolean stopped = false;
        private Set<TestingThread> testThreads = new HashSet<TestingThread>();
        private Set<TestingThread> finishedThreads = new HashSet<TestingThread>();

        public synchronized boolean shouldRun() {
            return !this.stopped && this.err == null;
        }

        public void addThread(TestingThread t) {
            this.testThreads.add(t);
        }

        public void startThreads() {
            for (TestingThread t : this.testThreads) {
                t.start();
            }
        }

        public synchronized void waitFor(long millis) throws Exception {
            long left;
            long endTime = System.currentTimeMillis() + millis;
            while (this.shouldRun() && this.finishedThreads.size() < this.testThreads.size() && (left = endTime - System.currentTimeMillis()) > 0L) {
                this.checkException();
                this.wait(left);
            }
            this.checkException();
        }

        private synchronized void checkException() throws Exception {
            if (this.err != null) {
                throw new RuntimeException("Deferred", this.err);
            }
        }

        public synchronized void threadFailed(Throwable t) {
            if (this.err == null) {
                this.err = t;
            }
            LOG.error((Object)"Failed!", this.err);
            this.notify();
        }

        public synchronized void threadDone(TestingThread t) {
            this.finishedThreads.add(t);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws Exception {
            TestContext testContext = this;
            synchronized (testContext) {
                this.stopped = true;
            }
            for (TestingThread t : this.testThreads) {
                t.join();
            }
            this.checkException();
        }
    }
}

