/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class GenericTestUtils {
    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    public static void assertExists(File f) {
        Assert.assertTrue((String)("File " + f + " should exist"), (boolean)f.exists());
    }

    public static void assertGlobEquals(File dir, String pattern, String ... expectedMatches) throws IOException {
        TreeSet found = Sets.newTreeSet();
        for (File f : FileUtil.listFiles((File)dir)) {
            if (!f.getName().matches(pattern)) continue;
            found.add(f.getName());
        }
        TreeSet expectedSet = Sets.newTreeSet(Arrays.asList(expectedMatches));
        Assert.assertEquals((String)("Bad files matching " + pattern + " in " + dir), (Object)Joiner.on((String)",").join((Iterable)found), (Object)Joiner.on((String)",").join((Iterable)expectedSet));
    }

    public static void assertExceptionContains(String string, Throwable t) {
        String msg = t.getMessage();
        Assert.assertTrue((String)("Unexpected exception:" + StringUtils.stringifyException((Throwable)t)), (boolean)msg.contains(string));
    }

    public static void waitFor(Supplier<Boolean> check, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        long st = System.currentTimeMillis();
        do {
            boolean result;
            if (result = ((Boolean)check.get()).booleanValue()) {
                return;
            }
            Thread.sleep(checkEveryMillis);
        } while (System.currentTimeMillis() - st < (long)waitForMillis);
        throw new TimeoutException("Timed out waiting for condition");
    }

    public static class DelegateAnswer
    implements Answer<Object> {
        private final Object delegate;

        public DelegateAnswer(Object delegate) {
            this.delegate = delegate;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            return invocation.getMethod().invoke(this.delegate, invocation.getArguments());
        }
    }

    public static class DelayAnswer
    implements Answer<Object> {
        private final Log LOG;
        private final CountDownLatch fireLatch = new CountDownLatch(1);
        private final CountDownLatch waitLatch = new CountDownLatch(1);

        public DelayAnswer(Log log) {
            this.LOG = log;
        }

        public void waitForCall() throws InterruptedException {
            this.fireLatch.await();
        }

        public void proceed() {
            this.waitLatch.countDown();
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            this.LOG.info((Object)"DelayAnswer firing fireLatch");
            this.fireLatch.countDown();
            try {
                this.LOG.info((Object)"DelayAnswer waiting on waitLatch");
                this.waitLatch.await();
                this.LOG.info((Object)"DelayAnswer delay complete");
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted waiting on latch", ie);
            }
            return this.passThrough(invocation);
        }

        protected Object passThrough(InvocationOnMock invocation) throws Throwable {
            return invocation.callRealMethod();
        }
    }
}

