/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAuthenticationFilter
extends TestCase {
    public void testConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.foo", "bar");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Assert.assertEquals((Object)"authentication", (Object)args[0]);
                Assert.assertEquals((Object)AuthenticationFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                Assert.assertEquals((String)"/", (String)((String)conf.get("cookie.path")));
                Assert.assertEquals((String)"simple", (String)((String)conf.get("type")));
                Assert.assertEquals((String)"36000", (String)((String)conf.get("token.validity")));
                Assert.assertEquals((String)"hadoop", (String)((String)conf.get("signature.secret")));
                Assert.assertNull(conf.get("cookie.domain"));
                Assert.assertEquals((String)"true", (String)((String)conf.get("simple.anonymous.allowed")));
                Assert.assertEquals((String)"HTTP/localhost@LOCALHOST", (String)((String)conf.get("kerberos.principal")));
                Assert.assertEquals((String)(System.getProperty("user.home") + "/hadoop.keytab"), (String)((String)conf.get("kerberos.keytab")));
                Assert.assertEquals((String)"bar", (String)((String)conf.get("foo")));
                return null;
            }
        }).when((Object)container)).addFilter((String)Mockito.anyObject(), (String)Mockito.anyObject(), (Map)Mockito.anyObject());
        new AuthenticationFilterInitializer().initFilter(container, conf);
    }
}

