/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.NameNotFoundException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.DNS;

public class TestDNS
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDNS.class);
    private static final String DEFAULT = "default";

    public TestDNS(String name) {
        super(name);
    }

    public void testGetLocalHost() throws Exception {
        String hostname = DNS.getDefaultHost((String)DEFAULT);
        TestDNS.assertNotNull((Object)hostname);
    }

    public void testGetLocalHostIsFast() throws Exception {
        String hostname = DNS.getDefaultHost((String)DEFAULT);
        TestDNS.assertNotNull((Object)hostname);
        long t1 = System.currentTimeMillis();
        String hostname2 = DNS.getDefaultHost((String)DEFAULT);
        long t2 = System.currentTimeMillis();
        String hostname3 = DNS.getDefaultHost((String)DEFAULT);
        long t3 = System.currentTimeMillis();
        TestDNS.assertEquals((String)hostname3, (String)hostname2);
        TestDNS.assertEquals((String)hostname2, (String)hostname);
        long interval2 = t3 - t2;
        TestDNS.assertTrue((String)"It is taking to long to determine the local host -caching is not working", (interval2 < 20000L ? 1 : 0) != 0);
    }

    public void testLocalHostHasAnAddress() throws Exception {
        TestDNS.assertNotNull((Object)this.getLocalIPAddr());
    }

    private InetAddress getLocalIPAddr() throws UnknownHostException {
        String hostname = DNS.getDefaultHost((String)DEFAULT);
        InetAddress localhost = InetAddress.getByName(hostname);
        return localhost;
    }

    public void testNullInterface() throws Exception {
        try {
            String host = DNS.getDefaultHost(null);
            TestDNS.fail((String)("Expected a NullPointerException, got " + host));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIPsOfUnknownInterface() throws Exception {
        String[] ips = DNS.getIPs((String)"name-of-an-unknown-interface");
        TestDNS.assertNotNull((Object)ips);
        TestDNS.assertTrue((ips.length > 0 ? 1 : 0) != 0);
    }

    public void testRDNS() throws Exception {
        block2: {
            InetAddress localhost = this.getLocalIPAddr();
            try {
                String s = DNS.reverseDns((InetAddress)localhost, null);
                LOG.info((Object)("Local revers DNS hostname is " + s));
            }
            catch (NameNotFoundException e) {
                if (localhost.isLinkLocalAddress() && !localhost.isLoopbackAddress()) break block2;
                LOG.info((Object)"Reverse DNS failing as due to incomplete networking", (Throwable)e);
                LOG.info((Object)("Address is " + localhost + " Loopback=" + localhost.isLoopbackAddress() + " Linklocal=" + localhost.isLinkLocalAddress()));
            }
        }
    }

    public void testLocalhostResolves() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        TestDNS.assertNotNull((String)"localhost is null", (Object)localhost);
        LOG.info((Object)("Localhost IPAddr is " + localhost.toString()));
    }
}

