/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.NoRouteToHostException;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.log.Log4Json;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableInformation;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.node.ContainerNode;
import org.junit.Test;

public class TestLog4Json
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestLog4Json.class);
    private static final JsonFactory factory = new MappingJsonFactory();

    @Test
    public void testConstruction() throws Throwable {
        Log4Json l4j = new Log4Json();
        String outcome = l4j.toJson((Writer)new StringWriter(), "name", 0L, "DEBUG", "thread1", "hello, world", null).toString();
        this.println("testConstruction", outcome);
    }

    @Test
    public void testException() throws Throwable {
        NoRouteToHostException e = new NoRouteToHostException("that box caught fire 3 years ago");
        ThrowableInformation ti = new ThrowableInformation((Throwable)e);
        Log4Json l4j = new Log4Json();
        long timeStamp = System.currentTimeMillis();
        String outcome = l4j.toJson((Writer)new StringWriter(), "testException", timeStamp, "INFO", "quoted\"", "new line\n and {}", ti).toString();
        this.println("testException", outcome);
    }

    @Test
    public void testNestedException() throws Throwable {
        NoRouteToHostException e = new NoRouteToHostException("that box caught fire 3 years ago");
        IOException ioe = new IOException("Datacenter problems", e);
        ThrowableInformation ti = new ThrowableInformation((Throwable)ioe);
        Log4Json l4j = new Log4Json();
        long timeStamp = System.currentTimeMillis();
        String outcome = l4j.toJson((Writer)new StringWriter(), "testNestedException", timeStamp, "INFO", "quoted\"", "new line\n and {}", ti).toString();
        this.println("testNestedException", outcome);
        ContainerNode rootNode = Log4Json.parse((String)outcome);
        this.assertEntryEquals(rootNode, "level", "INFO");
        this.assertEntryEquals(rootNode, "name", "testNestedException");
        this.assertEntryEquals(rootNode, "time", timeStamp);
        this.assertEntryEquals(rootNode, "exceptionclass", ioe.getClass().getName());
        JsonNode node = this.assertNodeContains(rootNode, "stack");
        TestLog4Json.assertTrue((String)("Not an array: " + node), (boolean)node.isArray());
        node = this.assertNodeContains(rootNode, "date");
        TestLog4Json.assertTrue((String)("Not a string: " + node), (boolean)node.isTextual());
        String dateText = node.getTextValue();
        TestLog4Json.assertTrue((String)("No '-' in " + dateText), (boolean)dateText.contains("-"));
        TestLog4Json.assertTrue((String)("No '-' in " + dateText), (boolean)dateText.contains(":"));
    }

    @Test
    public void testLog() throws Throwable {
        String message = "test message";
        Throwable throwable = null;
        String json = this.logOut(message, throwable);
        this.println("testLog", json);
    }

    @Test
    public void testLogExceptions() throws Throwable {
        String message = "test message";
        IOException inner = new IOException("Directory / not found");
        IOException throwable = new IOException("startup failure", inner);
        String json = this.logOut(message, throwable);
        this.println("testLogExceptions", json);
    }

    void assertEntryEquals(ContainerNode rootNode, String key, String value) {
        JsonNode node = this.assertNodeContains(rootNode, key);
        TestLog4Json.assertEquals((String)value, (String)node.getTextValue());
    }

    private JsonNode assertNodeContains(ContainerNode rootNode, String key) {
        JsonNode node = rootNode.get(key);
        if (node == null) {
            TestLog4Json.fail((String)("No entry of name \"" + key + "\" found in " + rootNode.toString()));
        }
        return node;
    }

    void assertEntryEquals(ContainerNode rootNode, String key, long value) {
        JsonNode node = this.assertNodeContains(rootNode, key);
        TestLog4Json.assertEquals((Object)value, (Object)node.getNumberValue());
    }

    private void println(String name, String text) {
        System.out.println(name + ": #" + text + "#");
    }

    private String logOut(String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        Logger logger = this.createLogger(writer);
        logger.info((Object)message, throwable);
        logger.removeAllAppenders();
        return writer.toString();
    }

    public Logger createLogger(Writer writer) {
        TestLoggerRepository repo = new TestLoggerRepository();
        Logger logger = repo.getLogger("test");
        Log4Json layout = new Log4Json();
        WriterAppender appender = new WriterAppender((Layout)layout, writer);
        logger.addAppender((Appender)appender);
        return logger;
    }

    public static class TestLoggerRepository
    implements LoggerRepository {
        public void addHierarchyEventListener(HierarchyEventListener listener) {
        }

        public boolean isDisabled(int level) {
            return false;
        }

        public void setThreshold(Level level) {
        }

        public void setThreshold(String val) {
        }

        public void emitNoAppenderWarning(Category cat) {
        }

        public Level getThreshold() {
            return Level.ALL;
        }

        public Logger getLogger(String name) {
            return new TestLogger(name, this);
        }

        public Logger getLogger(String name, LoggerFactory factory) {
            return new TestLogger(name, this);
        }

        public Logger getRootLogger() {
            return new TestLogger("root", this);
        }

        public Logger exists(String name) {
            return null;
        }

        public void shutdown() {
        }

        public Enumeration getCurrentLoggers() {
            return new Vector().elements();
        }

        public Enumeration getCurrentCategories() {
            return new Vector().elements();
        }

        public void fireAddAppenderEvent(Category logger, Appender appender) {
        }

        public void resetConfiguration() {
        }
    }

    private static class TestLogger
    extends Logger {
        private TestLogger(String name, LoggerRepository repo) {
            super(name);
            this.repository = repo;
            this.setLevel(Level.INFO);
        }
    }
}

