/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avro.AvroRemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.AvroRpcEngine;
import org.apache.hadoop.ipc.AvroSpecificRpcEngine;
import org.apache.hadoop.ipc.AvroSpecificTestProtocol;
import org.apache.hadoop.ipc.AvroTestProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class TestAvroRpc
extends TestCase {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestAvroRpc.class);
    int datasize = 102400;
    int numThreads = 50;

    public TestAvroRpc(String name) {
        super(name);
    }

    public void testReflect() throws Exception {
        this.testReflect(false);
    }

    public void testSecureReflect() throws Exception {
        this.testReflect(true);
    }

    public void testSpecific() throws Exception {
        this.testSpecific(false);
    }

    public void testSecureSpecific() throws Exception {
        this.testSpecific(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReflect(boolean secure) throws Exception {
        Configuration conf = new Configuration();
        TestSaslRPC.TestTokenSecretManager sm = null;
        if (secure) {
            this.makeSecure(conf);
            sm = new TestSaslRPC.TestTokenSecretManager();
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.setProtocolEngine((Configuration)conf, AvroTestProtocol.class, AvroRpcEngine.class);
        RPC.Server server = RPC.getServer(AvroTestProtocol.class, (Object)new TestImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        try {
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            if (secure) {
                this.addToken(sm, addr);
                Assert.assertEquals((String)"auth", (String)((String)SaslRpcServer.SASL_PROPS.get("javax.security.sasl.qop")));
            }
            AvroTestProtocol proxy = (AvroTestProtocol)RPC.getProxy(AvroTestProtocol.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
            proxy.ping();
            String echo = proxy.echo("hello world");
            TestAvroRpc.assertEquals((String)"hello world", (String)echo);
            int intResult = proxy.add(1, 2);
            TestAvroRpc.assertEquals((int)3, (int)intResult);
            boolean caught = false;
            try {
                proxy.error();
            }
            catch (AvroRemoteException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught " + (Object)((Object)e)));
                }
                caught = true;
            }
            TestAvroRpc.assertTrue((boolean)caught);
        }
        finally {
            this.resetSecurity();
            server.stop();
        }
    }

    private void makeSecure(Configuration conf) {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.rpc.socket.factory.class.default", "");
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new TestSaslRPC.CustomSecurityInfo()});
    }

    private void resetSecurity() {
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[0]);
    }

    private void addToken(TestSaslRPC.TestTokenSecretManager sm, InetSocketAddress addr) throws IOException {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSpecific(boolean secure) throws Exception {
        Configuration conf = new Configuration();
        TestSaslRPC.TestTokenSecretManager sm = null;
        if (secure) {
            this.makeSecure(conf);
            sm = new TestSaslRPC.TestTokenSecretManager();
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.setProtocolEngine((Configuration)conf, AvroSpecificTestProtocol.class, AvroSpecificRpcEngine.class);
        RPC.Server server = RPC.getServer(AvroSpecificTestProtocol.class, (Object)new AvroSpecificTestProtocolImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        try {
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            if (secure) {
                this.addToken(sm, addr);
                Assert.assertEquals((String)"auth", (String)((String)SaslRpcServer.SASL_PROPS.get("javax.security.sasl.qop")));
            }
            AvroSpecificTestProtocol proxy = (AvroSpecificTestProtocol)RPC.getProxy(AvroSpecificTestProtocol.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
            CharSequence echo = proxy.echo("hello world");
            TestAvroRpc.assertEquals((String)"hello world", (String)((Object)echo).toString());
            int intResult = proxy.add(1, 2);
            TestAvroRpc.assertEquals((int)3, (int)intResult);
        }
        finally {
            this.resetSecurity();
            server.stop();
        }
    }

    public static class AvroSpecificTestProtocolImpl
    implements AvroSpecificTestProtocol {
        @Override
        public int add(int arg1, int arg2) throws AvroRemoteException {
            return arg1 + arg2;
        }

        @Override
        public CharSequence echo(CharSequence msg) throws AvroRemoteException {
            return msg;
        }
    }

    public static class TestImpl
    implements AvroTestProtocol {
        @Override
        public void ping() {
        }

        @Override
        public String echo(String value) {
            return value;
        }

        @Override
        public int add(int v1, int v2) {
            return v1 + v2;
        }

        @Override
        public int error() throws AvroTestProtocol.Problem {
            throw new AvroTestProtocol.Problem();
        }
    }
}

