/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;

public class UnreliableImplementation
implements UnreliableInterface {
    private int failsOnceInvocationCount;
    private int failsOnceWithValueInvocationCount;
    private int failsTenTimesInvocationCount;
    private int succeedsOnceThenFailsCount;
    private int succeedsOnceThenFailsIdempotentCount;
    private int succeedsTenTimesThenFailsCount;
    private String identifier;
    private TypeOfExceptionToFailWith exceptionToFailWith;

    public UnreliableImplementation() {
        this(null);
    }

    public UnreliableImplementation(String identifier) {
        this(identifier, TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION);
    }

    public UnreliableImplementation(String identifier, TypeOfExceptionToFailWith exceptionToFailWith) {
        this.identifier = identifier;
        this.exceptionToFailWith = exceptionToFailWith;
    }

    @Override
    public void alwaysSucceeds() {
    }

    @Override
    public void alwaysFailsWithFatalException() throws UnreliableInterface.FatalException {
        throw new UnreliableInterface.FatalException();
    }

    @Override
    public void alwaysFailsWithRemoteFatalException() throws RemoteException {
        throw new RemoteException(UnreliableInterface.FatalException.class.getName(), "Oops");
    }

    @Override
    public void failsOnceThenSucceeds() throws UnreliableInterface.UnreliableException {
        if (this.failsOnceInvocationCount++ == 0) {
            throw new UnreliableInterface.UnreliableException();
        }
    }

    @Override
    public boolean failsOnceThenSucceedsWithReturnValue() throws UnreliableInterface.UnreliableException {
        if (this.failsOnceWithValueInvocationCount++ == 0) {
            throw new UnreliableInterface.UnreliableException();
        }
        return true;
    }

    @Override
    public void failsTenTimesThenSucceeds() throws UnreliableInterface.UnreliableException {
        if (this.failsTenTimesInvocationCount++ < 10) {
            throw new UnreliableInterface.UnreliableException();
        }
    }

    @Override
    public String succeedsOnceThenFailsReturningString() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        if (this.succeedsOnceThenFailsCount++ < 1) {
            return this.identifier;
        }
        switch (this.exceptionToFailWith) {
            case STANDBY_EXCEPTION: {
                throw new StandbyException(this.identifier);
            }
            case UNRELIABLE_EXCEPTION: {
                throw new UnreliableInterface.UnreliableException(this.identifier);
            }
            case IO_EXCEPTION: {
                throw new IOException(this.identifier);
            }
        }
        return null;
    }

    @Override
    public String succeedsTenTimesThenFailsReturningString() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        if (this.succeedsTenTimesThenFailsCount++ < 10) {
            return this.identifier;
        }
        switch (this.exceptionToFailWith) {
            case STANDBY_EXCEPTION: {
                throw new StandbyException(this.identifier);
            }
            case UNRELIABLE_EXCEPTION: {
                throw new UnreliableInterface.UnreliableException(this.identifier);
            }
            case IO_EXCEPTION: {
                throw new IOException(this.identifier);
            }
        }
        throw new RuntimeException(this.identifier);
    }

    @Override
    public String succeedsOnceThenFailsReturningStringIdempotent() throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        if (this.succeedsOnceThenFailsIdempotentCount++ < 1) {
            return this.identifier;
        }
        switch (this.exceptionToFailWith) {
            case STANDBY_EXCEPTION: {
                throw new StandbyException(this.identifier);
            }
            case UNRELIABLE_EXCEPTION: {
                throw new UnreliableInterface.UnreliableException(this.identifier);
            }
            case IO_EXCEPTION: {
                throw new IOException(this.identifier);
            }
        }
        throw new RuntimeException(this.identifier);
    }

    public static enum TypeOfExceptionToFailWith {
        UNRELIABLE_EXCEPTION,
        STANDBY_EXCEPTION,
        IO_EXCEPTION;

    }
}

