/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.StandbyException;
import org.junit.Assert;
import org.junit.Test;

public class TestFailoverProxy {
    @Test
    public void testSuccedsOnceThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2")), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded more than twice");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testSucceedsTenTimesThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2")), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
        }
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
    }

    @Test
    public void testNeverFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2")), (RetryPolicy)RetryPolicies.TRY_ONCE_DONT_FAIL);
        unreliable.succeedsOnceThenFailsReturningString();
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
    }

    @Test
    public void testFailoverOnStandbyException() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2")), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION), new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION)), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
    }

    @Test
    public void testFailoverOnNetworkExceptionIdempotentOperation() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (FailoverProxyProvider)new FlipFlopProxyProvider(UnreliableInterface.class, new UnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.IO_EXCEPTION), new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION)), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
    }

    public static class FailOverOnceOnAnyExceptionPolicy
    implements RetryPolicy {
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) {
            return failovers < 1 ? RetryPolicy.RetryAction.FAILOVER_AND_RETRY : RetryPolicy.RetryAction.FAIL;
        }
    }

    public static class FlipFlopProxyProvider
    implements FailoverProxyProvider {
        private Class<?> iface;
        private Object currentlyActive;
        private Object impl1;
        private Object impl2;

        public FlipFlopProxyProvider(Class<?> iface, Object activeImpl, Object standbyImpl) {
            this.iface = iface;
            this.impl1 = activeImpl;
            this.impl2 = standbyImpl;
            this.currentlyActive = this.impl1;
        }

        public Object getProxy() {
            return this.currentlyActive;
        }

        public void performFailover(Object currentProxy) {
            this.currentlyActive = this.impl1 == currentProxy ? this.impl2 : this.impl1;
        }

        public Class<?> getInterface() {
            return this.iface;
        }
    }
}

