/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class TestText
extends TestCase {
    private static final int NUM_ITERATIONS = 100;
    private static final Random RANDOM = new Random(1L);
    private static final int RAND_LEN = -1;

    public TestText(String name) {
        super(name);
    }

    private static String getTestString(int len) throws Exception {
        int length;
        StringBuilder buffer = new StringBuilder();
        int n = length = len == -1 ? RANDOM.nextInt(1000) : len;
        while (buffer.length() < length) {
            int codePoint = RANDOM.nextInt(0x10FFFF);
            char[] tmpStr = new char[2];
            if (!Character.isDefined(codePoint) || codePoint >= 65536 || Character.isHighSurrogate((char)codePoint) || Character.isLowSurrogate((char)codePoint)) continue;
            Character.toChars(codePoint, tmpStr, 0);
            buffer.append(tmpStr);
        }
        return buffer.toString();
    }

    public static String getTestString() throws Exception {
        return TestText.getTestString(-1);
    }

    public static String getLongString() throws Exception {
        String str = TestText.getTestString();
        int length = Short.MAX_VALUE + str.length();
        StringBuilder buffer = new StringBuilder();
        while (buffer.length() < length) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public void testWritable() throws Exception {
        for (int i = 0; i < 100; ++i) {
            String str = i == 0 ? TestText.getLongString() : TestText.getTestString();
            TestWritable.testWritable((Writable)new Text(str));
        }
    }

    public void testCoding() throws Exception {
        String before = "Bad \t encoding \t testcase";
        Text text = new Text(before);
        String after = text.toString();
        TestText.assertTrue((boolean)before.equals(after));
        for (int i = 0; i < 100; ++i) {
            before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            ByteBuffer bb = Text.encode((String)before);
            byte[] utf8Text = bb.array();
            byte[] utf8Java = before.getBytes("UTF-8");
            TestText.assertEquals((int)0, (int)WritableComparator.compareBytes((byte[])utf8Text, (int)0, (int)bb.limit(), (byte[])utf8Java, (int)0, (int)utf8Java.length));
            after = Text.decode((byte[])utf8Java);
            TestText.assertTrue((boolean)before.equals(after));
        }
    }

    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 100; ++i) {
            String before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            out.reset();
            Text.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = Text.readString((DataInput)in);
            TestText.assertTrue((boolean)before.equals(after));
            int strLenSize = WritableUtils.getVIntSize((long)Text.utf8Length((String)before));
            String after2 = new String(out.getData(), strLenSize, out.getLength() - strLenSize, "UTF-8");
            TestText.assertTrue((boolean)before.equals(after2));
        }
    }

    public void testCompare() throws Exception {
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        DataOutputBuffer out3 = new DataOutputBuffer();
        Text.Comparator comparator = new Text.Comparator();
        for (int i = 0; i < 100; ++i) {
            out1.reset();
            out2.reset();
            out3.reset();
            String str1 = TestText.getTestString();
            String str2 = TestText.getTestString();
            if (i == 0) {
                str1 = TestText.getLongString();
                str2 = TestText.getLongString();
            } else {
                str1 = TestText.getTestString();
                str2 = TestText.getTestString();
            }
            Text txt1 = new Text(str1);
            Text txt2 = new Text(str2);
            Text txt3 = new Text(str1);
            txt1.write((DataOutput)out1);
            txt2.write((DataOutput)out2);
            txt3.write((DataOutput)out3);
            int ret1 = comparator.compare(out1.getData(), 0, out1.getLength(), out2.getData(), 0, out2.getLength());
            int ret2 = txt1.compareTo((BinaryComparable)txt2);
            TestText.assertEquals((int)ret1, (int)ret2);
            TestText.assertEquals((int)txt1.compareTo((BinaryComparable)txt3), (int)0);
            TestText.assertEquals((int)comparator.compare(out1.getData(), 0, out3.getLength(), out3.getData(), 0, out3.getLength()), (int)0);
        }
    }

    public void testFind() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        TestText.assertTrue((text.find("abd") == -1 ? 1 : 0) != 0);
        TestText.assertTrue((text.find("ac") == -1 ? 1 : 0) != 0);
        TestText.assertTrue((text.find("\u20ac") == 4 ? 1 : 0) != 0);
        TestText.assertTrue((text.find("\u20ac", 5) == 11 ? 1 : 0) != 0);
    }

    public void testFindAfterUpdatingContents() throws Exception {
        Text text = new Text("abcd");
        text.set("a".getBytes());
        TestText.assertEquals((int)text.getLength(), (int)1);
        TestText.assertEquals((int)text.find("a"), (int)0);
        TestText.assertEquals((int)text.find("b"), (int)-1);
    }

    public void testValidate() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        byte[] utf8 = text.getBytes();
        int length = text.getLength();
        Text.validateUTF8((byte[])utf8, (int)0, (int)length);
    }

    public void testTextText() throws CharacterCodingException {
        Text a = new Text("abc");
        Text b = new Text("a");
        b.set(a);
        TestText.assertEquals((String)"abc", (String)b.toString());
        a.append("xdefgxxx".getBytes(), 1, 4);
        TestText.assertEquals((String)"modified aliased string", (String)"abc", (String)b.toString());
        TestText.assertEquals((String)"appended string incorrectly", (String)"abcdefg", (String)a.toString());
        a.append(new byte[]{100}, 0, 1);
        TestText.assertEquals((int)14, (int)a.getBytes().length);
        TestText.assertEquals((int)8, (int)a.copyBytes().length);
    }

    public void testConcurrentEncodeDecode() throws Exception {
        ConcurrentEncodeDecodeThread thread1 = new ConcurrentEncodeDecodeThread("apache");
        ConcurrentEncodeDecodeThread thread2 = new ConcurrentEncodeDecodeThread("hadoop");
        thread1.start();
        thread2.start();
        thread2.join();
        thread2.join();
    }

    public void testAvroReflect() throws Exception {
        AvroTestUtil.testReflect(new Text("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.io.Text\"}");
    }

    public static void main(String[] args) throws Exception {
        TestText test = new TestText("main");
        test.testIO();
        test.testCompare();
        test.testCoding();
        test.testWritable();
        test.testFind();
        test.testValidate();
    }

    private class ConcurrentEncodeDecodeThread
    extends Thread {
        public ConcurrentEncodeDecodeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            String name = this.getName();
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (int i = 0; i < 1000; ++i) {
                try {
                    out.reset();
                    WritableUtils.writeString((DataOutput)out, (String)name);
                    in.reset(out.getData(), out.getLength());
                    String s = WritableUtils.readString((DataInput)in);
                    Assert.assertEquals((String)name, (String)s);
                    continue;
                }
                catch (Exception ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }
}

