/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIOUtils {
    @Test
    public void testCopyBytesShouldCloseStreamsWhenCloseIsTrue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldCloseInputSteamWhenOutputStreamCloseThrowsException() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)outputStream)).close();
        try {
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldNotCloseStreamsWhenCloseIsFalse() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)false);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atMost((int)0))).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atMost((int)0))).close();
    }

    @Test
    public void testCopyBytesWithCountShouldCloseStreamsWhenCloseIsTrue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)true);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesWithCountShouldNotCloseStreamsWhenCloseIsFalse() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)false);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atMost((int)0))).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atMost((int)0))).close();
    }

    @Test
    public void testCopyBytesWithCountShouldThrowOutTheStreamClosureExceptions() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException("Exception in closing the stream")).when((Object)outputStream)).close();
        try {
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)true);
            Assert.fail((String)"Should throw out the exception");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Not throwing the expected exception.", (Object)"Exception in closing the stream", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipFully() throws IOException {
        byte[] inArray = new byte[]{0, 1, 2, 3, 4};
        ByteArrayInputStream in = new ByteArrayInputStream(inArray);
        try {
            in.mark(inArray.length);
            IOUtils.skipFully((InputStream)in, (long)2L);
            IOUtils.skipFully((InputStream)in, (long)2L);
            try {
                IOUtils.skipFully((InputStream)in, (long)2L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 1 byte(s).");
            }
            in.reset();
            try {
                IOUtils.skipFully((InputStream)in, (long)20L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 5 byte(s).");
            }
            in.reset();
            IOUtils.skipFully((InputStream)in, (long)5L);
            try {
                IOUtils.skipFully((InputStream)in, (long)10L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 0 byte(s).");
            }
        }
        finally {
            in.close();
        }
    }
}

