/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.Test;

public class TestServletFilter
extends HttpServerFunctionalTest {
    static final Log LOG = LogFactory.getLog(HttpServer.class);
    static volatile String uri = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(String urlstring) throws IOException {
        LOG.warn((Object)("access " + urlstring));
        URL url = new URL(urlstring);
        URLConnection connection = url.openConnection();
        connection.connect();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                while (in.readLine() != null) {
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("urlstring=" + urlstring), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletFilter() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", SimpleFilter.Initializer.class.getName());
        HttpServer http = TestServletFilter.createTestServer(conf);
        http.start();
        String fsckURL = "/fsck";
        String stacksURL = "/stacks";
        String ajspURL = "/a.jsp";
        String logURL = "/logs/a.log";
        String hadooplogoURL = "/static/hadoop-logo.jpg";
        String[] urls = new String[]{"/fsck", "/stacks", "/a.jsp", "/logs/a.log", "/static/hadoop-logo.jpg"};
        Random ran = new Random();
        int[] sequence = new int[50];
        for (int i = 0; i < sequence.length; ++i) {
            sequence[i] = ran.nextInt(urls.length);
        }
        String prefix = "http://localhost:" + http.getPort();
        try {
            for (int i = 0; i < sequence.length; ++i) {
                TestServletFilter.access(prefix + urls[sequence[i]]);
                if (sequence[i] == 0) {
                    TestServletFilter.assertEquals(null, (Object)uri);
                    continue;
                }
                TestServletFilter.assertEquals((Object)urls[sequence[i]], (Object)uri);
                uri = null;
            }
        }
        finally {
            http.stop();
        }
    }

    public static class SimpleFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info((Object)("filtering " + uri));
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("simple", SimpleFilter.class.getName(), null);
            }
        }
    }
}

