/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;

public class ViewFsTestSetup {
    public static FileContext setupForViewFsLocalFs() throws Exception {
        String srcTestFirstDir;
        FileContext fclocal = FileContext.getLocalFSFileContext();
        Path targetOfTests = FileContextTestHelper.getTestRootPath(fclocal);
        fclocal.delete(targetOfTests, true);
        fclocal.mkdir(targetOfTests, FileContext.DEFAULT_PERM, true);
        if (FileContextTestHelper.TEST_ROOT_DIR.startsWith("/")) {
            int indexOf2ndSlash = FileContextTestHelper.TEST_ROOT_DIR.indexOf(47, 1);
            srcTestFirstDir = FileContextTestHelper.TEST_ROOT_DIR.substring(0, indexOf2ndSlash);
        } else {
            srcTestFirstDir = "/user";
        }
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)srcTestFirstDir, (URI)targetOfTests.toUri());
        FileContext fc = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        return fc;
    }

    public static void tearDownForViewFsLocalFs() throws Exception {
        FileContext fclocal = FileContext.getLocalFSFileContext();
        Path targetOfTests = FileContextTestHelper.getTestRootPath(fclocal);
        fclocal.delete(targetOfTests, true);
    }
}

