/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestViewFsTrash {
    FileSystem fsTarget;
    FileSystem fsView;
    Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.fsTarget = FileSystem.getLocal((Configuration)new Configuration());
        this.fsTarget.mkdirs(new Path(FileSystemTestHelper.getTestRootPath(this.fsTarget), "dir1"));
        this.conf = ViewFileSystemTestSetup.createConfig();
        this.fsView = ViewFileSystemTestSetup.setupForViewFileSystem(this.conf, this.fsTarget);
        this.conf.set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
    }

    @After
    public void tearDown() throws Exception {
        ViewFileSystemTestSetup.tearDown(this.fsTarget);
        this.fsTarget.delete(new Path(this.fsTarget.getHomeDirectory(), ".Trash/Current"), true);
    }

    @Test
    public void testTrash() throws IOException {
        TestTrash.trashShell(this.conf, FileSystemTestHelper.getTestRootPath(this.fsView), this.fsTarget, new Path(this.fsTarget.getHomeDirectory(), ".Trash/Current"));
    }

    static class TestLFS
    extends LocalFileSystem {
        Path home;

        TestLFS() throws IOException {
            this(new Path(FileSystemTestHelper.TEST_ROOT_DIR));
        }

        TestLFS(Path home) throws IOException {
            this.home = home;
        }

        public Path getHomeDirectory() {
            return this.home;
        }
    }
}

