/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFileSystemWithAuthorityLocalFileSystem
extends ViewFileSystemBaseTest {
    URI schemeWithAuthority;

    @Override
    @Before
    public void setUp() throws Exception {
        this.fsTarget = FileSystem.getLocal((Configuration)new Configuration());
        super.setUp();
        this.schemeWithAuthority = new URI("viewfs", "default", "/", null, null);
        this.fsView = FileSystem.get((URI)this.schemeWithAuthority, (Configuration)this.conf);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(FileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        super.tearDown();
    }

    @Override
    @Test
    public void testBasicPaths() {
        Assert.assertEquals((Object)this.schemeWithAuthority, (Object)this.fsView.getUri());
        Assert.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getWorkingDirectory());
        Assert.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(this.schemeWithAuthority, null), (Object)this.fsView.makeQualified(new Path("/foo/bar")));
    }
}

