/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFileSystemDelegation {
    static Configuration conf;
    static FileSystem viewFs;
    static FakeFileSystem fs1;
    static FakeFileSystem fs2;

    @BeforeClass
    public static void setup() throws Exception {
        conf = ViewFileSystemTestSetup.createConfig();
        fs1 = TestViewFileSystemDelegation.setupFileSystem(new URI("fs1:/"), FakeFileSystem.class);
        fs2 = TestViewFileSystemDelegation.setupFileSystem(new URI("fs2:/"), FakeFileSystem.class);
        viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
    }

    static FakeFileSystem setupFileSystem(URI uri, Class clazz) throws Exception {
        String scheme = uri.getScheme();
        conf.set("fs." + scheme + ".impl", clazz.getName());
        FakeFileSystem fs = (FakeFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Path targetPath = FileSystemTestHelper.getAbsoluteTestRootPath((FileSystem)fs);
        ConfigUtil.addLink((Configuration)conf, (String)("/mounts/" + scheme), (URI)targetPath.toUri());
        return fs;
    }

    @Test
    public void testSanity() {
        Assert.assertEquals((Object)"fs1:/", (Object)fs1.getUri().toString());
        Assert.assertEquals((Object)"fs2:/", (Object)fs2.getUri().toString());
    }

    @Test
    public void testVerifyChecksum() throws Exception {
        this.checkVerifyChecksum(false);
        this.checkVerifyChecksum(true);
    }

    void checkVerifyChecksum(boolean flag) {
        viewFs.setVerifyChecksum(flag);
        Assert.assertEquals((Object)flag, (Object)fs1.getVerifyChecksum());
        Assert.assertEquals((Object)flag, (Object)fs2.getVerifyChecksum());
    }

    static class FakeFileSystem
    extends LocalFileSystem {
        boolean verifyChecksum = true;
        URI uri;

        FakeFileSystem() {
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
            super.initialize(uri, conf);
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setVerifyChecksum(boolean verifyChecksum) {
            this.verifyChecksum = verifyChecksum;
        }

        public boolean getVerifyChecksum() {
            return this.verifyChecksum;
        }
    }
}

