/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPathData {
    protected Configuration conf;
    protected FileSystem fs;
    protected Path testDir;

    @Before
    public void initialize() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(System.getProperty("test.build.data", "build/test/data") + "/testPD");
        this.testDir = new Path(this.fs.makeQualified(this.testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fs.getUri());
        this.fs.setWorkingDirectory(this.testDir);
        this.fs.mkdirs(new Path("d1"));
        this.fs.createNewFile(new Path("d1", "f1"));
        this.fs.createNewFile(new Path("d1", "f1.1"));
        this.fs.createNewFile(new Path("d1", "f2"));
        this.fs.mkdirs(new Path("d2"));
        this.fs.create(new Path("d2", "f3"));
    }

    @After
    public void cleanup() throws Exception {
        this.fs.close();
    }

    @Test
    public void testWithDirStringAndConf() throws Exception {
        String dirString = "d1";
        PathData item = new PathData(dirString, this.conf);
        this.checkPathData(dirString, item);
        dirString = "d1/";
        item = new PathData(dirString, this.conf);
        this.checkPathData(dirString, item);
    }

    @Test
    public void testUnqualifiedUriContents() throws Exception {
        String dirString = "d1";
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1", "d1/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testQualifiedUriContents() throws Exception {
        String dirString = this.fs.makeQualified(new Path("d1")).toString();
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString(dirString + "/f1", dirString + "/f1.1", dirString + "/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testCwdContents() throws Exception {
        String dirString = ".";
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1", "d2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testToFile() throws Exception {
        PathData item = new PathData(".", this.conf);
        Assert.assertEquals((Object)new File(this.testDir.toString()), (Object)item.toFile());
        item = new PathData("d1/f1", this.conf);
        Assert.assertEquals((Object)new File(this.testDir + "/d1/f1"), (Object)item.toFile());
        item = new PathData(this.testDir + "/d1/f1", this.conf);
        Assert.assertEquals((Object)new File(this.testDir + "/d1/f1"), (Object)item.toFile());
    }

    @Test
    public void testAbsoluteGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)(this.testDir + "/d1/f1*"), (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString(this.testDir + "/d1/f1", this.testDir + "/d1/f1.1"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testRelativeGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)"d1/f1*", (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testRelativeGlobBack() throws Exception {
        this.fs.setWorkingDirectory(new Path("d1"));
        PathData[] items = PathData.expandAsGlob((String)"../d2/*", (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString("../d2/f3"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testWithStringAndConfForBuggyPath() throws Exception {
        String dirString = "file:///tmp";
        Path tmpDir = new Path(dirString);
        PathData item = new PathData(dirString, this.conf);
        Assert.assertEquals((Object)"file:/tmp", (Object)tmpDir.toString());
        this.checkPathData(dirString, item);
    }

    public void checkPathData(String dirString, PathData item) throws Exception {
        Assert.assertEquals((String)"checking fs", (Object)this.fs, (Object)item.fs);
        Assert.assertEquals((String)"checking string", (Object)dirString, (Object)item.toString());
        Assert.assertEquals((String)"checking path", (Object)this.fs.makeQualified(new Path(item.toString())), (Object)item.path);
        Assert.assertTrue((String)"checking exist", (item.stat != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"checking isDir", (boolean)item.stat.isDirectory());
    }

    private static String sortedString(Object ... list) {
        Object[] strings = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            strings[i] = String.valueOf(list[i]);
        }
        Arrays.sort(strings);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(i + ":<" + (String)strings[i] + ">");
        }
        return result.toString();
    }

    private static String sortedString(PathData ... items) {
        return TestPathData.sortedString((Object[])items);
    }
}

