/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestListFiles {
    static final long seed = 3735928559L;
    protected static final Configuration conf = new Configuration();
    protected static FileSystem fs;
    protected static final Path TEST_DIR;
    private static final int FILE_LEN = 10;
    private static final Path FILE1;
    private static final Path DIR1;
    private static final Path FILE2;
    private static final Path FILE3;

    public TestListFiles() {
        ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.ALL);
    }

    protected static Path getTestDir() {
        return new Path(System.getProperty("test.build.data", "build/test/data/work-dir/localfs"), "main_");
    }

    @BeforeClass
    public static void testSetUp() throws Exception {
        fs = FileSystem.getLocal((Configuration)conf);
        fs.delete(TEST_DIR, true);
    }

    private static void writeFile(FileSystem fileSys, Path name, int fileSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @Test
    public void testFile() throws IOException {
        fs.mkdirs(TEST_DIR);
        TestListFiles.writeFile(fs, FILE1, 10);
        RemoteIterator itor = fs.listFiles(FILE1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        itor = fs.listFiles(FILE1, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        fs.delete(FILE1, true);
    }

    @Test
    public void testDirectory() throws IOException {
        fs.mkdirs(DIR1);
        RemoteIterator itor = fs.listFiles(DIR1, true);
        Assert.assertFalse((boolean)itor.hasNext());
        itor = fs.listFiles(DIR1, false);
        Assert.assertFalse((boolean)itor.hasNext());
        TestListFiles.writeFile(fs, FILE2, 10);
        itor = fs.listFiles(DIR1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fs.makeQualified(FILE2), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        itor = fs.listFiles(DIR1, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fs.makeQualified(FILE2), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        TestListFiles.writeFile(fs, FILE1, 10);
        TestListFiles.writeFile(fs, FILE3, 10);
        HashSet<Path> filesToFind = new HashSet<Path>();
        filesToFind.add(fs.makeQualified(FILE1));
        filesToFind.add(fs.makeQualified(FILE2));
        filesToFind.add(fs.makeQualified(FILE3));
        itor = fs.listFiles(TEST_DIR, true);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertTrue((String)("Path " + stat.getPath() + " unexpected"), (boolean)filesToFind.remove(stat.getPath()));
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertTrue((String)("Path " + stat.getPath() + " unexpected"), (boolean)filesToFind.remove(stat.getPath()));
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertTrue((String)("Path " + stat.getPath() + " unexpected"), (boolean)filesToFind.remove(stat.getPath()));
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)filesToFind.isEmpty());
        itor = fs.listFiles(TEST_DIR, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertFalse((boolean)itor.hasNext());
        fs.delete(TEST_DIR, true);
    }

    static {
        TEST_DIR = TestListFiles.getTestDir();
        FILE1 = new Path(TEST_DIR, "file1");
        DIR1 = new Path(TEST_DIR, "dir1");
        FILE2 = new Path(DIR1, "file2");
        FILE3 = new Path(DIR1, "file3");
    }
}

