/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class TestHarFileSystem {
    @Test
    public void testHarUri() {
        Configuration conf = new Configuration();
        TestHarFileSystem.checkInvalidPath("har://hdfs-/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://hdfs/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://-hdfs/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://-/foo.har", conf);
    }

    static void checkInvalidPath(String s, Configuration conf) {
        System.out.println("\ncheckInvalidPath: " + s);
        Path p = new Path(s);
        try {
            p.getFileSystem(conf);
            Assert.fail((String)(p + " is an invalid path."));
        }
        catch (IOException e) {
            System.out.println("GOOD: Got an exception.");
            e.printStackTrace(System.out);
        }
    }

    @Test
    public void testFileChecksum() {
        Path p = new Path("har://file-localhost/foo.har/file1");
        HarFileSystem harfs = new HarFileSystem();
        Assert.assertEquals(null, (Object)harfs.getFileChecksum(p));
    }

    @Test
    public void testFixBlockLocations() {
        BlockLocation[] b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)20L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)10L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)20L, (long)15L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)10L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)6L, (long)12L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)6L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)20L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)10L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)20L, (long)15L);
        Assert.assertEquals((long)b[0].getOffset(), (long)3L);
        Assert.assertEquals((long)b[0].getLength(), (long)2L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)7L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)3L, (long)12L);
        Assert.assertEquals((long)b[0].getOffset(), (long)3L);
        Assert.assertEquals((long)b[0].getLength(), (long)3L);
        b = new BlockLocation[]{new BlockLocation(null, null, 512L, 512L), new BlockLocation(null, null, 1024L, 512L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)512L, (long)896L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)128L);
        Assert.assertEquals((long)b[1].getOffset(), (long)128L);
        Assert.assertEquals((long)b[1].getLength(), (long)384L);
    }
}

