/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.log.Log;

public abstract class FSMainOperationsBaseTest {
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    protected static FileSystem fSys;
    private static final PathFilter DEFAULT_FILTER;
    private static final PathFilter TEST_X_FILTER;
    protected static final byte[] data;

    @Before
    public void setUp() throws Exception {
        fSys.mkdirs(FileSystemTestHelper.getTestRootPath(fSys, "test"));
    }

    @After
    public void tearDown() throws Exception {
        fSys.delete(new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test")), true);
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return FileSystemTestHelper.getTestRootPath(fSys, "/user/" + System.getProperty("user.name")).makeQualified(fSys.getUri(), fSys.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = fSys.getStatus(null);
        Assert.assertNotNull((Object)fsStatus);
        Assert.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test"));
        fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        fSys.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        fSys.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)fSys.getWorkingDirectory());
        workDir = new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test"));
        fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
        absoluteDir = FileSystemTestHelper.getTestRootPath(fSys, "test/existingDir2");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        FileSystemTestHelper.createFile(fSys, absolutePath);
        fSys.open(new Path("foo")).close();
        fSys.mkdirs(new Path("newDir"));
        Assert.assertTrue((boolean)FileSystemTestHelper.isDir(fSys, new Path(absoluteDir, "newDir")));
    }

    @Test
    public void testWDAbsolute() throws IOException {
        Path absoluteDir = new Path(fSys.getUri() + "/test/existingDir");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        Path parentDir = testDir.getParent();
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, parentDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, grandparentDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
        Path testSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/subdir");
        try {
            fSys.mkdirs(testSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testSubDir));
        Path testDeepSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/deep/sub/dir");
        try {
            fSys.mkdirs(testDeepSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDeepSubDir));
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fSys.getFileStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListStatusThrowsExceptionForUnreadableDir() throws Exception {
        Path testRootDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        Path obscuredDir = new Path(testRootDir, "foo");
        Path subDir = new Path(obscuredDir, "bar");
        fSys.mkdirs(subDir);
        fSys.setPermission(obscuredDir, new FsPermission(0));
        try {
            fSys.listStatus(obscuredDir);
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException ioe) {
        }
        finally {
            fSys.setPermission(obscuredDir, new FsPermission(493));
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"), FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/b"), FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/c/1")};
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDirs[0]));
        for (Path path : testDirs) {
            fSys.mkdirs(path);
        }
        FileStatus[] paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test"));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), (Object)paths[0].getPath());
        paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"));
        Assert.assertEquals((long)3L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/b"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/c"), paths));
        paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusNonExistentFile() throws Exception {
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoopfsdf"));
        Assert.assertNull((Object)paths);
        paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoopfsdf/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
        paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoopfsdf/xyz*/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop*"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop*/*"));
        Assert.assertEquals((long)4L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/ax?"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"), DEFAULT_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/*"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a??"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/*"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a??"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FileSystemTestHelper.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize() * 2);
    }

    protected void writeReadAndDelete(int len) throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        fSys.mkdirs(path.getParent());
        FSDataOutputStream out = fSys.create(path, false, 4096, (short)1, (long)FileSystemTestHelper.getDefaultBlockSize());
        out.write(data, 0, len);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)len, (long)fSys.getFileStatus(path).getLen());
        FSDataInputStream in = fSys.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assert.assertEquals((long)len, (long)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)data[i], (long)buf[i]);
        }
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(path, false));
        Assert.assertFalse((String)"No longer exists", (boolean)FileSystemTestHelper.exists(fSys, path));
    }

    @Test
    public void testOverwrite() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        fSys.mkdirs(path.getParent());
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
        try {
            this.createFile(path);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FSDataOutputStream out = fSys.create(path, true, 4096);
        out.write(data, 0, data.length);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Parent doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, path.getParent()));
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
        Assert.assertTrue((String)"Parent exists", (boolean)FileSystemTestHelper.exists(fSys, path.getParent()));
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertFalse((String)"No deletion", (boolean)fSys.delete(path, true));
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Path file = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Path subdir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/subdir");
        this.createFile(file);
        fSys.mkdirs(subdir);
        Assert.assertTrue((String)"File exists", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertTrue((String)"Dir exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Subdir exists", (boolean)FileSystemTestHelper.exists(fSys, subdir));
        try {
            fSys.delete(dir, false);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertTrue((String)"File still exists", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertTrue((String)"Dir still exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Subdir still exists", (boolean)FileSystemTestHelper.exists(fSys, subdir));
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(dir, true));
        Assert.assertFalse((String)"File doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertFalse((String)"Subdir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, subdir));
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        fSys.mkdirs(dir);
        Assert.assertTrue((String)"Dir exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(dir, false));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, dir));
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/nonExistent");
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newpath");
        try {
            this.rename(src, dst, false, false, false, Options.Rename.NONE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Log.info((String)"XXX", (Object)e);
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, false, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/nonExistent/newfile");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToDestinationWithParentFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/parentFile/newfile");
        this.createFile(dst.getParent());
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileToExistingParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newfile");
        fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/existingFile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/existingDir");
        fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, false, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, false, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToNonExistentParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/nonExistent/newdir");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameDirectoryAsNonExistentDirectory() throws Exception {
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.NONE);
        this.tearDown();
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.OVERWRITE);
    }

    private void doTestRenameDirectoryAsNonExistentDirectory(Options.Rename ... options) throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/file1"));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir");
        fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, options);
        Assert.assertFalse((String)"Nested file1 exists", (boolean)FileSystemTestHelper.exists(fSys, FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/file1")));
        Assert.assertFalse((String)"Nested file2 exists", (boolean)FileSystemTestHelper.exists(fSys, FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/subdir/file2")));
        Assert.assertTrue((String)"Renamed nested file1 exists", (boolean)FileSystemTestHelper.exists(fSys, FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir/file1")));
        Assert.assertTrue((String)"Renamed nested exists", (boolean)FileSystemTestHelper.exists(fSys, FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir/subdir/file2")));
    }

    @Test
    public void testRenameDirectoryAsEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/file1"));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir");
        fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameDirectoryAsNonEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/file1"));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir");
        fSys.mkdirs(dst);
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/new/newdir/file1"));
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryAsFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/dir");
        fSys.mkdirs(src);
        Path dst = FileSystemTestHelper.getTestRootPath(fSys, "test/new/newfile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = fSys.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        FSDataOutputStream out = fSys.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    @Test
    public void testGetWrappedInputStream() throws IOException {
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = fSys.open(src);
        InputStream is = in.getWrappedStream();
        in.close();
        Assert.assertNotNull((Object)is);
    }

    @Test
    public void testCopyToLocalWithUseRawLocalFileSystemOption() throws Exception {
        Configuration conf = new Configuration();
        RawLocalFileSystem fSys = new RawLocalFileSystem();
        Path fileToFS = new Path(FileSystemTestHelper.TEST_ROOT_DIR, "fs.txt");
        Path fileToLFS = new Path(FileSystemTestHelper.TEST_ROOT_DIR, "test.txt");
        Path crcFileAtLFS = new Path(FileSystemTestHelper.TEST_ROOT_DIR, ".test.txt.crc");
        fSys.initialize(new URI("file:///"), conf);
        this.writeFile((FileSystem)fSys, fileToFS);
        if (fSys.exists(crcFileAtLFS)) {
            Assert.assertTrue((String)"CRC files not deleted", (boolean)fSys.delete(crcFileAtLFS, true));
        }
        fSys.copyToLocalFile(false, fileToFS, fileToLFS, true);
        Assert.assertFalse((String)"CRC files are created", (boolean)fSys.exists(crcFileAtLFS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(FileSystem fs, Path name) throws IOException {
        FSDataOutputStream stm = fs.create(name);
        try {
            stm.writeBytes("42\n");
        }
        finally {
            stm.close();
        }
    }

    protected void createFile(Path path) throws IOException {
        FileSystemTestHelper.createFile(fSys, path);
    }

    private void rename(Path src, Path dst, boolean renameShouldSucceed, boolean srcExists, boolean dstExists, Options.Rename ... options) throws IOException {
        fSys.rename(src, dst, options);
        if (!renameShouldSucceed) {
            Assert.fail((String)"rename should have thrown exception");
        }
        Assert.assertEquals((String)"Source exists", (Object)srcExists, (Object)FileSystemTestHelper.exists(fSys, src));
        Assert.assertEquals((String)"Destination exists", (Object)dstExists, (Object)FileSystemTestHelper.exists(fSys, dst));
    }

    private boolean containsPath(Path path, FileStatus[] filteredPaths) throws IOException {
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!FileSystemTestHelper.getTestRootPath(fSys, path.toString()).equals((Object)filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return true;
            }
        };
        TEST_X_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().contains("x") || file.toString().contains("X");
            }
        };
        data = FileSystemTestHelper.getFileData(numBlocks, FileSystemTestHelper.getDefaultBlockSize());
    }
}

