/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReconfiguration {
    private Configuration conf1;
    private Configuration conf2;
    private static final String PROP1 = "test.prop.one";
    private static final String PROP2 = "test.prop.two";
    private static final String PROP3 = "test.prop.three";
    private static final String PROP4 = "test.prop.four";
    private static final String PROP5 = "test.prop.five";
    private static final String VAL1 = "val1";
    private static final String VAL2 = "val2";

    @Before
    public void setUp() {
        this.conf1 = new Configuration();
        this.conf2 = new Configuration();
        this.conf1.set(PROP1, VAL1);
        this.conf1.set(PROP2, VAL1);
        this.conf1.set(PROP3, VAL1);
        this.conf2.set(PROP1, VAL1);
        this.conf2.set(PROP2, VAL2);
        this.conf2.set(PROP4, VAL1);
    }

    @Test
    public void testGetChangedProperties() {
        Collection changes = ReconfigurationUtil.getChangedProperties((Configuration)this.conf2, (Configuration)this.conf1);
        Assert.assertTrue((String)("expected 3 changed properties but got " + changes.size()), (changes.size() == 3 ? 1 : 0) != 0);
        boolean changeFound = false;
        boolean unsetFound = false;
        boolean setFound = false;
        for (ReconfigurationUtil.PropertyChange c : changes) {
            if (c.prop.equals(PROP2) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal != null && c.newVal.equals(VAL2)) {
                changeFound = true;
                continue;
            }
            if (c.prop.equals(PROP3) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal == null) {
                unsetFound = true;
                continue;
            }
            if (!c.prop.equals(PROP4) || c.oldVal != null || c.newVal == null || !c.newVal.equals(VAL1)) continue;
            setFound = true;
        }
        Assert.assertTrue((String)"not all changes have been applied", (changeFound && unsetFound && setFound ? 1 : 0) != 0);
    }

    @Test
    public void testReconfigure() {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertTrue((String)"test.prop.one set to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL1));
        Assert.assertTrue((String)"test.prop.two set to wrong value ", (boolean)dummy.getConf().get(PROP2).equals(VAL1));
        Assert.assertTrue((String)"test.prop.three set to wrong value ", (boolean)dummy.getConf().get(PROP3).equals(VAL1));
        Assert.assertTrue((String)"test.prop.four set to wrong value ", (dummy.getConf().get(PROP4) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"test.prop.five set to wrong value ", (dummy.getConf().get(PROP5) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"test.prop.one should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP1));
        Assert.assertTrue((String)"test.prop.two should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP2));
        Assert.assertFalse((String)"test.prop.three should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP3));
        Assert.assertTrue((String)"test.prop.four should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP4));
        Assert.assertFalse((String)"test.prop.five should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP5));
        boolean exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL1);
            Assert.assertTrue((String)"test.prop.one set to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL1));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, null);
            Assert.assertTrue((String)"test.prop.oneset to wrong value ", (dummy.getConf().get(PROP1) == null ? 1 : 0) != 0);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL2);
            Assert.assertTrue((String)"test.prop.oneset to wrong value ", (boolean)dummy.getConf().get(PROP1).equals(VAL2));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, null);
            Assert.assertTrue((String)"test.prop.fourset to wrong value ", (dummy.getConf().get(PROP4) == null ? 1 : 0) != 0);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, VAL1);
            Assert.assertTrue((String)"test.prop.fourset to wrong value ", (boolean)dummy.getConf().get(PROP4).equals(VAL1));
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, VAL1);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, VAL2);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (boolean)exceptionCaught);
    }

    @Test
    public void testThread() throws ReconfigurationException {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertTrue((boolean)dummy.getConf().get(PROP1).equals(VAL1));
        Thread dummyThread = new Thread(dummy);
        dummyThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        dummy.reconfigureProperty(PROP1, VAL2);
        long endWait = System.currentTimeMillis() + 2000L;
        while (dummyThread.isAlive() && System.currentTimeMillis() < endWait) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignore) {}
        }
        Assert.assertFalse((String)"dummy thread should not be alive", (boolean)dummyThread.isAlive());
        dummy.running = false;
        try {
            dummyThread.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        Assert.assertTrue((String)"test.prop.one is set to wrong value", (boolean)dummy.getConf().get(PROP1).equals(VAL2));
    }

    public static class ReconfigurableDummy
    extends ReconfigurableBase
    implements Runnable {
        public volatile boolean running = true;

        public ReconfigurableDummy(Configuration conf) {
            super(conf);
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReconfiguration.PROP1, TestReconfiguration.PROP2, TestReconfiguration.PROP4);
        }

        public synchronized void reconfigurePropertyImpl(String property, String newVal) {
        }

        @Override
        public void run() {
            while (this.running && this.getConf().get(TestReconfiguration.PROP1).equals(TestReconfiguration.VAL1)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

