/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.versioning.Version;
import org.apache.zookeeper.AsyncCallback;

public interface LedgerManager
extends Closeable {
    public void createLedger(LedgerMetadata var1, BookkeeperInternalCallbacks.GenericCallback<Long> var2);

    public void removeLedgerMetadata(long var1, Version var3, BookkeeperInternalCallbacks.GenericCallback<Void> var4);

    public void readLedgerMetadata(long var1, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> var3);

    public void writeLedgerMetadata(long var1, LedgerMetadata var3, BookkeeperInternalCallbacks.GenericCallback<Void> var4);

    public void registerLedgerMetadataListener(long var1, BookkeeperInternalCallbacks.LedgerMetadataListener var3);

    public void unregisterLedgerMetadataListener(long var1, BookkeeperInternalCallbacks.LedgerMetadataListener var3);

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> var1, AsyncCallback.VoidCallback var2, Object var3, int var4, int var5);

    public LedgerRangeIterator getLedgerRanges();

    public static interface LedgerRangeIterator {
        public boolean hasNext() throws IOException;

        public LedgerRange next() throws IOException;
    }

    public static class LedgerRange {
        private final SortedSet<Long> ledgers;

        public LedgerRange(Set<Long> ledgers) {
            this.ledgers = new TreeSet<Long>(ledgers);
        }

        public int size() {
            return this.ledgers.size();
        }

        public Long start() {
            return this.ledgers.first();
        }

        public Long end() {
            return this.ledgers.last();
        }

        public Set<Long> getLedgers() {
            return this.ledgers;
        }
    }
}

