/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.ZkVersion;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HierarchicalLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(HierarchicalLedgerManager.class);
    static final String IDGEN_ZNODE = "idgen";
    static final String IDGENERATION_PREFIX = "/idgen/ID-";
    private static final String MAX_ID_SUFFIX = "9999";
    private static final String MIN_ID_SUFFIX = "0000";
    private final String idGenPath;

    public HierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
        this.idGenPath = this.ledgerRootPath + IDGENERATION_PREFIX;
        LOG.debug("Using HierarchicalLedgerManager with root path : {}", (Object)this.ledgerRootPath);
    }

    @Override
    public void createLedger(final LedgerMetadata metadata, final BookkeeperInternalCallbacks.GenericCallback<Long> ledgerCb) {
        ZkUtils.asyncCreateFullPathOptimistic(this.zk, this.idGenPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, final String idPathName) {
                long ledgerId;
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not generate new ledger id", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    ledgerCb.operationComplete(-9, null);
                    return;
                }
                try {
                    ledgerId = HierarchicalLedgerManager.this.getLedgerIdFromGenPath(idPathName);
                }
                catch (IOException e) {
                    LOG.error("Could not extract ledger-id from id gen path:" + path, (Throwable)e);
                    ledgerCb.operationComplete(-9, null);
                    return;
                }
                String ledgerPath = HierarchicalLedgerManager.this.getLedgerPath(ledgerId);
                final long lid = ledgerId;
                AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Could not create node for ledger", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                            ledgerCb.operationComplete(-9, null);
                        } else {
                            metadata.setVersion(new ZkVersion(0));
                            ledgerCb.operationComplete(0, lid);
                        }
                    }
                };
                ZkUtils.asyncCreateFullPathOptimistic(HierarchicalLedgerManager.this.zk, ledgerPath, metadata.serialize(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, scb, null);
                HierarchicalLedgerManager.this.scheduler.submit(new Runnable(){

                    @Override
                    public void run() {
                        HierarchicalLedgerManager.this.zk.delete(idPathName, -1, new AsyncCallback.VoidCallback(){

                            public void processResult(int rc, String path, Object ctx) {
                                if (rc != KeeperException.Code.OK.intValue()) {
                                    LOG.warn("Exception during deleting znode for id generation : ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                                } else {
                                    LOG.debug("Deleting znode for id generation : {}", (Object)idPathName);
                                }
                            }
                        }, null);
                    }
                });
            }
        }, null);
    }

    private long getLedgerIdFromGenPath(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(IDGENERATION_PREFIX);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getHierarchicalLedgerPath(ledgerId);
    }

    @Override
    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToHierarchicalLedgerId(hierarchicalPath);
    }

    private long getLedgerId(String ... levelNodes) throws IOException {
        return StringUtils.stringToHierarchicalLedgerId(levelNodes);
    }

    private long getStartLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MIN_ID_SUFFIX);
    }

    private long getEndLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MAX_ID_SUFFIX);
    }

    @Override
    public void asyncProcessLedgers(final BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new BookkeeperInternalCallbacks.Processor<String>(){

            @Override
            public void process(final String l1Node, AsyncCallback.VoidCallback cb1) {
                if (HierarchicalLedgerManager.this.isSpecialZnode(l1Node)) {
                    cb1.processResult(successRc, null, context);
                    return;
                }
                String l1NodePath = HierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node;
                HierarchicalLedgerManager.this.asyncProcessLevelNodes(l1NodePath, new BookkeeperInternalCallbacks.Processor<String>(){

                    @Override
                    public void process(String l2Node, AsyncCallback.VoidCallback cb2) {
                        String l2NodePath = HierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node + "/" + l2Node;
                        HierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(l2NodePath, processor, cb2, context, successRc, failureRc);
                    }
                }, cb1, context, successRc, failureRc);
            }
        }, finalCb, context, successRc, failureRc);
    }

    private void asyncProcessLevelNodes(String path, final BookkeeperInternalCallbacks.Processor<String> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.zk.sync(path, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Error syncing path " + path + " when getting its chidren: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    finalCb.processResult(failureRc, null, context);
                    return;
                }
                HierarchicalLedgerManager.this.zk.getChildren(path, false, new AsyncCallback.ChildrenCallback(){

                    public void processResult(int rc, String path, Object ctx, List<String> levelNodes) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Error polling hash nodes of " + path, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                            finalCb.processResult(failureRc, null, context);
                            return;
                        }
                        AsyncListProcessor<String> listProcessor = new AsyncListProcessor<String>(HierarchicalLedgerManager.this.scheduler);
                        listProcessor.process(levelNodes, processor, finalCb, context, successRc, failureRc);
                    }
                }, null);
            }
        }, null);
    }

    @Override
    protected boolean isSpecialZnode(String znode) {
        return IDGEN_ZNODE.equals(znode) || super.isSpecialZnode(znode);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        return new HierarchicalLedgerRangeIterator();
    }

    private class HierarchicalLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        private Iterator<String> l1NodesIter = null;
        private Iterator<String> l2NodesIter = null;
        private String curL1Nodes = "";
        private boolean iteratorDone = false;
        private LedgerManager.LedgerRange nextRange = null;

        private HierarchicalLedgerRangeIterator() {
        }

        private boolean nextL1Node() throws KeeperException, InterruptedException {
            this.l2NodesIter = null;
            while (this.l2NodesIter == null) {
                if (!this.l1NodesIter.hasNext()) {
                    return false;
                }
                this.curL1Nodes = this.l1NodesIter.next();
                if (HierarchicalLedgerManager.this.isSpecialZnode(this.curL1Nodes)) continue;
                List l2Nodes = HierarchicalLedgerManager.this.zk.getChildren(HierarchicalLedgerManager.this.ledgerRootPath + "/" + this.curL1Nodes, null);
                Collections.sort(l2Nodes);
                this.l2NodesIter = l2Nodes.iterator();
                if (this.l2NodesIter.hasNext()) continue;
                this.l2NodesIter = null;
            }
            return true;
        }

        private synchronized void preload() throws IOException {
            while (this.nextRange == null && !this.iteratorDone) {
                boolean hasMoreElements = false;
                try {
                    if (this.l1NodesIter == null) {
                        this.l1NodesIter = HierarchicalLedgerManager.this.zk.getChildren(HierarchicalLedgerManager.this.ledgerRootPath, null).iterator();
                        hasMoreElements = this.nextL1Node();
                    } else {
                        hasMoreElements = this.l2NodesIter == null || !this.l2NodesIter.hasNext() ? this.nextL1Node() : true;
                    }
                }
                catch (KeeperException ke) {
                    throw new IOException("Error preloading next range", ke);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while preloading", ie);
                }
                if (hasMoreElements) {
                    this.nextRange = this.getLedgerRangeByLevel(this.curL1Nodes, this.l2NodesIter.next());
                    if (this.nextRange.size() != 0) continue;
                    this.nextRange = null;
                    continue;
                }
                this.iteratorDone = true;
            }
        }

        @Override
        public synchronized boolean hasNext() throws IOException {
            this.preload();
            return this.nextRange != null && !this.iteratorDone;
        }

        @Override
        public synchronized LedgerManager.LedgerRange next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LedgerManager.LedgerRange r = this.nextRange;
            this.nextRange = null;
            return r;
        }

        LedgerManager.LedgerRange getLedgerRangeByLevel(String level1, String level2) throws IOException {
            StringBuilder nodeBuilder = new StringBuilder();
            nodeBuilder.append(HierarchicalLedgerManager.this.ledgerRootPath).append("/").append(level1).append("/").append(level2);
            String nodePath = nodeBuilder.toString();
            List<String> ledgerNodes = null;
            try {
                ledgerNodes = ZkUtils.getChildrenInSingleNode(HierarchicalLedgerManager.this.zk, nodePath);
            }
            catch (InterruptedException e) {
                throw new IOException("Error when get child nodes from zk", e);
            }
            NavigableSet<Long> zkActiveLedgers = HierarchicalLedgerManager.this.ledgerListToSet(ledgerNodes, nodePath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("All active ledgers from ZK for hash node " + level1 + "/" + level2 + " : " + zkActiveLedgers);
            }
            return new LedgerManager.LedgerRange(zkActiveLedgers.subSet(HierarchicalLedgerManager.this.getStartLedgerIdByLevel(level1, level2), true, HierarchicalLedgerManager.this.getEndLedgerIdByLevel(level1, level2), true));
        }
    }

    private static class AsyncListProcessor<T> {
        ScheduledExecutorService scheduler;

        public AsyncListProcessor(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
        }

        public void process(final List<T> data, final BookkeeperInternalCallbacks.Processor<T> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (data == null || data.size() == 0) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            final int size = data.size();
            final AtomicInteger current = new AtomicInteger(0);
            AsyncCallback.VoidCallback stubCallback = new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (rc != successRc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    int next = current.incrementAndGet();
                    if (next >= size) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    final Object dataToProcess = data.get(next);
                    final 1 stub = this;
                    AsyncListProcessor.this.scheduler.submit(new Runnable(){

                        @Override
                        public final void run() {
                            processor.process(dataToProcess, stub);
                        }
                    });
                }
            };
            T firstElement = data.get(0);
            processor.process(firstElement, stubCallback);
        }
    }
}

