/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.ZkVersion;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlatLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(FlatLedgerManager.class);
    private final String ledgerPrefix;

    public FlatLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
        this.ledgerPrefix = this.ledgerRootPath + "/" + "L";
    }

    @Override
    public void createLedger(final LedgerMetadata metadata, final BookkeeperInternalCallbacks.GenericCallback<Long> cb) {
        AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    LOG.error("Could not create node for ledger", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    cb.operationComplete(-9, null);
                } else {
                    metadata.setVersion(new ZkVersion(0));
                    try {
                        long ledgerId = FlatLedgerManager.this.getLedgerId(name);
                        cb.operationComplete(0, ledgerId);
                    }
                    catch (IOException ie) {
                        LOG.error("Could not extract ledger-id from path:" + name, (Throwable)ie);
                        cb.operationComplete(-9, null);
                    }
                }
            }
        };
        ZkUtils.asyncCreateFullPathOptimistic(this.zk, this.ledgerPrefix, metadata.serialize(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, scb, null);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ledgerPrefix).append(StringUtils.getZKStringId(ledgerId));
        return sb.toString();
    }

    @Override
    public long getLedgerId(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(this.ledgerPrefix);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object ctx, int successRc, int failureRc) {
        this.asyncProcessLedgersInSingleNode(this.ledgerRootPath, processor, finalCb, ctx, successRc, failureRc);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        return new LedgerManager.LedgerRangeIterator(){
            boolean nextCalled = false;
            LedgerManager.LedgerRange nextRange = null;

            private synchronized void preload() throws IOException {
                if (this.nextRange != null) {
                    return;
                }
                NavigableSet<Long> zkActiveLedgers = null;
                try {
                    zkActiveLedgers = FlatLedgerManager.this.ledgerListToSet(ZkUtils.getChildrenInSingleNode(FlatLedgerManager.this.zk, FlatLedgerManager.this.ledgerRootPath), FlatLedgerManager.this.ledgerRootPath);
                    this.nextRange = new LedgerManager.LedgerRange(zkActiveLedgers);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Error when get child nodes from zk", ie);
                }
            }

            @Override
            public synchronized boolean hasNext() throws IOException {
                this.preload();
                return this.nextRange != null && this.nextRange.size() > 0 && !this.nextCalled;
            }

            @Override
            public synchronized LedgerManager.LedgerRange next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextCalled = true;
                return this.nextRange;
            }
        };
    }
}

