/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingAddOp
implements BookkeeperInternalCallbacks.WriteCallback {
    static final Logger LOG = LoggerFactory.getLogger(PendingAddOp.class);
    ChannelBuffer toSend;
    AsyncCallback.AddCallback cb;
    Object ctx;
    long entryId;
    int entryLength;
    Set<Integer> writeSet;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    LedgerHandle lh;
    boolean isRecoveryAdd = false;

    PendingAddOp(LedgerHandle lh, AsyncCallback.AddCallback cb, Object ctx) {
        this.lh = lh;
        this.cb = cb;
        this.ctx = ctx;
        this.entryId = -1L;
        this.ackSet = lh.distributionSchedule.getAckSet();
    }

    PendingAddOp enableRecoveryAdd() {
        this.isRecoveryAdd = true;
        return this;
    }

    void setEntryId(long entryId) {
        this.entryId = entryId;
        this.writeSet = new HashSet<Integer>(this.lh.distributionSchedule.getWriteSet(entryId));
    }

    void sendWriteRequest(int bookieIndex) {
        int flags = this.isRecoveryAdd ? 2 : 0;
        this.lh.bk.bookieClient.addEntry(this.lh.metadata.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.entryId, this.toSend, this, bookieIndex, flags);
    }

    void unsetSuccessAndSendWriteRequest(int bookieIndex) {
        if (this.toSend == null) {
            return;
        }
        if (!this.writeSet.contains(bookieIndex)) {
            this.lh.sendAddSuccessCallbacks();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsetting success for ledger: " + this.lh.ledgerId + " entry: " + this.entryId + " bookie index: " + bookieIndex);
        }
        this.ackSet.removeBookie(bookieIndex);
        this.completed = false;
        this.sendWriteRequest(bookieIndex);
    }

    void initiate(ChannelBuffer toSend, int entryLength) {
        this.toSend = toSend;
        this.entryLength = entryLength;
        for (int bookieIndex : this.writeSet) {
            this.sendWriteRequest(bookieIndex);
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, InetSocketAddress addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        if (this.completed) {
            return;
        }
        switch (rc) {
            case 0: {
                break;
            }
            case -101: {
                LOG.warn("Fencing exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            case -102: {
                LOG.warn("Unauthorized access exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            default: {
                LOG.warn("Write did not succeed: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleBookieFailure(addr, bookieIndex);
                return;
            }
        }
        if (!this.writeSet.contains(bookieIndex)) {
            LOG.warn("Received a response for (lid:{}, eid:{}) from {}@{}, but it doesn't belong to {}.", new Object[]{ledgerId, entryId, addr, bookieIndex, this.writeSet});
            return;
        }
        if (this.ackSet.addBookieAndCheck(bookieIndex) && !this.completed) {
            this.completed = true;
            LOG.debug("Complete (lid:{}, eid:{}).", (Object)ledgerId, (Object)entryId);
            this.lh.sendAddSuccessCallbacks();
        }
    }

    void submitCallback(int rc) {
        if (rc != 0) {
            LOG.error("Write of ledger entry to quorum failed: L{} E{}", (Object)this.lh.getId(), (Object)this.entryId);
        }
        this.cb.addComplete(rc, this.lh, this.entryId, this.ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingAddOp(lid:").append(this.lh.ledgerId).append(", eid:").append(this.entryId).append(", completed:").append(this.completed).append(")");
        return sb.toString();
    }
}

