/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Enumeration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DigestManager;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.PendingReadOp;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerRecoveryOp
implements AsyncCallback.ReadCallback,
AsyncCallback.AddCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryOp.class);
    LedgerHandle lh;
    int numResponsesPending;
    boolean proceedingWithRecovery = false;
    long maxAddPushed = -1L;
    long maxAddConfirmed = -1L;
    long maxLength = 0L;
    LedgerMetadata metadataForRecovery;
    BookkeeperInternalCallbacks.GenericCallback<Void> cb;

    public LedgerRecoveryOp(LedgerHandle lh, BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        this.cb = cb;
        this.lh = lh;
        this.numResponsesPending = lh.metadata.getEnsembleSize();
    }

    public void initiate() {
        ReadLastConfirmedOp rlcop = new ReadLastConfirmedOp(this.lh, new ReadLastConfirmedOp.LastConfirmedDataCallback(){

            @Override
            public void readLastConfirmedDataComplete(int rc, DigestManager.RecoveryData data) {
                if (rc == 0) {
                    LedgerRecoveryOp.this.lh.lastAddPushed = LedgerRecoveryOp.this.lh.lastAddConfirmed = data.lastAddConfirmed;
                    LedgerRecoveryOp.this.lh.length = data.length;
                    LedgerRecoveryOp.this.metadataForRecovery = new LedgerMetadata(LedgerRecoveryOp.this.lh.getLedgerMetadata());
                    LedgerRecoveryOp.this.doRecoveryRead();
                } else if (rc == -102) {
                    LedgerRecoveryOp.this.cb.operationComplete(rc, null);
                } else {
                    LedgerRecoveryOp.this.cb.operationComplete(-1, null);
                }
            }
        });
        rlcop.initiateWithFencing();
    }

    private void doRecoveryRead() {
        long nextEntry = this.lh.lastAddConfirmed + 1L;
        try {
            new RecoveryReadOp(this.lh, this.lh.bk.scheduler, nextEntry, nextEntry, this, null).initiate();
        }
        catch (InterruptedException e) {
            this.readComplete(-15, this.lh, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
        if (rc == 0) {
            LedgerEntry entry = seq.nextElement();
            byte[] data = entry.getEntry();
            LedgerHandle ledgerHandle = lh;
            synchronized (ledgerHandle) {
                lh.length = entry.getLength() - (long)data.length;
            }
            lh.asyncRecoveryAddEntry(data, 0, data.length, this, null);
            return;
        }
        if (rc == -13 || rc == -7) {
            lh.asyncCloseInternal(new AsyncCallback.CloseCallback(){

                @Override
                public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                    if (rc != 0) {
                        LOG.warn("Close failed: " + BKException.getMessage(rc));
                        LedgerRecoveryOp.this.cb.operationComplete(rc, null);
                    } else {
                        LedgerRecoveryOp.this.cb.operationComplete(0, null);
                        LOG.debug("After closing length is: {}", (Object)lh.getLength());
                    }
                }
            }, null, -11);
            return;
        }
        LOG.error("Failure " + BKException.getMessage(rc) + " while reading entry: " + (lh.lastAddConfirmed + 1L) + " ledger: " + lh.ledgerId + " while recovering ledger");
        this.cb.operationComplete(rc, null);
    }

    @Override
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (rc != 0) {
            LOG.error("Failure " + BKException.getMessage(rc) + " while writing entry: " + (lh.lastAddConfirmed + 1L) + " ledger: " + lh.ledgerId + " while recovering ledger");
            this.cb.operationComplete(rc, null);
            return;
        }
        this.doRecoveryRead();
    }

    class RecoveryReadOp
    extends PendingReadOp {
        RecoveryReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, AsyncCallback.ReadCallback cb, Object ctx) {
            super(lh, scheduler, startEntryId, endEntryId, cb, ctx);
        }

        @Override
        protected LedgerMetadata getLedgerMetadata() {
            return LedgerRecoveryOp.this.metadataForRecovery;
        }
    }
}

