/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookiesListener;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerFragmentReplicator;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.SyncCounter;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperAdmin {
    private static Logger LOG = LoggerFactory.getLogger(BookKeeperAdmin.class);
    private ZooKeeper zk;
    private final String bookiesPath;
    private BookKeeper bkc;
    private LedgerFragmentReplicator lfr;
    private Random rand = new Random();

    public BookKeeperAdmin(String zkServers) throws IOException, InterruptedException, KeeperException {
        this(new ClientConfiguration().setZkServers(zkServers));
    }

    public BookKeeperAdmin(ClientConfiguration conf) throws IOException, InterruptedException, KeeperException {
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(conf.getZkTimeout());
        this.zk = ZkUtils.createConnectedZookeeperClient(conf.getZkServers(), w);
        this.bookiesPath = conf.getZkAvailableBookiesPath();
        this.bkc = new BookKeeper(conf, this.zk);
        this.lfr = new LedgerFragmentReplicator(this.bkc);
    }

    public BookKeeperAdmin(BookKeeper bkc) {
        this.bkc = bkc;
        this.zk = bkc.zk;
        this.bookiesPath = bkc.getConf().getZkAvailableBookiesPath();
        this.lfr = new LedgerFragmentReplicator(bkc);
    }

    public void close() throws InterruptedException, BKException {
        this.bkc.close();
        this.zk.close();
    }

    public Collection<InetSocketAddress> getAvailableBookies() throws BKException {
        return this.bkc.bookieWatcher.getBookies();
    }

    public Collection<InetSocketAddress> getReadOnlyBookies() {
        return this.bkc.bookieWatcher.getReadOnlyBookies();
    }

    public void notifyBookiesChanged(BookiesListener listener) throws BKException {
        this.bkc.bookieWatcher.notifyBookiesChanged(listener);
    }

    public void asyncOpenLedger(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, lId, cb, ctx).initiate();
    }

    public LedgerHandle openLedger(long lId) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        new LedgerOpenOp(this.bkc, lId, new BookKeeper.SyncOpenCallback(), counter).initiate();
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    public void asyncOpenLedgerNoRecovery(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, lId, cb, ctx).initiateWithoutRecovery();
    }

    public LedgerHandle openLedgerNoRecovery(long lId) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        new LedgerOpenOp(this.bkc, lId, new BookKeeper.SyncOpenCallback(), counter).initiateWithoutRecovery();
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverBookieData(InetSocketAddress bookieSrc, InetSocketAddress bookieDest) throws InterruptedException, BKException {
        SyncObject sync = new SyncObject();
        this.asyncRecoverBookieData(bookieSrc, bookieDest, new AsyncCallback.RecoverCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverComplete(int rc, Object ctx) {
                SyncObject syncObj;
                LOG.info("Recover bookie operation completed with rc: " + rc);
                SyncObject syncObject = syncObj = (SyncObject)ctx;
                synchronized (syncObject) {
                    syncObj.rc = rc;
                    syncObj.value = true;
                    syncObj.notify();
                }
            }
        }, sync);
        SyncObject syncObject = sync;
        synchronized (syncObject) {
            while (!sync.value) {
                sync.wait();
            }
        }
        if (sync.rc != 0) {
            throw BKException.create(sync.rc);
        }
    }

    public void asyncRecoverBookieData(final InetSocketAddress bookieSrc, final InetSocketAddress bookieDest, final AsyncCallback.RecoverCallback cb, final Object context) {
        this.zk.sync(this.bookiesPath, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("ZK error syncing: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    cb.recoverComplete(-9, context);
                    return;
                }
                BookKeeperAdmin.this.getAvailableBookies(bookieSrc, bookieDest, cb, context);
            }
        }, null);
    }

    private void getAvailableBookies(final InetSocketAddress bookieSrc, InetSocketAddress bookieDest, final AsyncCallback.RecoverCallback cb, final Object context) {
        final LinkedList<InetSocketAddress> availableBookies = new LinkedList<InetSocketAddress>();
        if (bookieDest != null) {
            availableBookies.add(bookieDest);
            this.getActiveLedgers(bookieSrc, bookieDest, cb, context, availableBookies);
        } else {
            this.zk.getChildren(this.bookiesPath, null, new AsyncCallback.ChildrenCallback(){

                public void processResult(int rc, String path, Object ctx, List<String> children) {
                    if (rc != KeeperException.Code.OK.intValue()) {
                        LOG.error("ZK error getting bookie nodes: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                        cb.recoverComplete(-9, context);
                        return;
                    }
                    for (String bookieNode : children) {
                        if ("readonly".equals(bookieNode)) continue;
                        String[] parts = bookieNode.split(":");
                        if (parts.length < 2) {
                            LOG.error("Bookie Node retrieved from ZK has invalid name format: " + bookieNode);
                            cb.recoverComplete(-9, context);
                            return;
                        }
                        availableBookies.add(new InetSocketAddress(parts[0], Integer.parseInt(parts[1])));
                    }
                    BookKeeperAdmin.this.getActiveLedgers(bookieSrc, null, cb, context, availableBookies);
                }
            }, null);
        }
    }

    private void getActiveLedgers(final InetSocketAddress bookieSrc, InetSocketAddress bookieDest, AsyncCallback.RecoverCallback cb, Object context, final List<InetSocketAddress> availableBookies) {
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long ledgerId, AsyncCallback.VoidCallback iterCallback) {
                BookKeeperAdmin.this.recoverLedger(bookieSrc, ledgerId, iterCallback, availableBookies);
            }
        };
        class RecoverCallbackWrapper
        implements AsyncCallback.VoidCallback {
            final AsyncCallback.RecoverCallback cb;

            RecoverCallbackWrapper(AsyncCallback.RecoverCallback cb) {
                this.cb = cb;
            }

            public void processResult(int rc, String path, Object ctx) {
                this.cb.recoverComplete(rc, ctx);
            }
        }
        this.bkc.getLedgerManager().asyncProcessLedgers(ledgerProcessor, new RecoverCallbackWrapper(cb), context, 0, -10);
    }

    private InetSocketAddress getNewBookie(List<InetSocketAddress> bookiesAlreadyInEnsemble, List<InetSocketAddress> availableBookies) throws BKException.BKNotEnoughBookiesException {
        ArrayList<InetSocketAddress> candidates = new ArrayList<InetSocketAddress>();
        candidates.addAll(availableBookies);
        candidates.removeAll(bookiesAlreadyInEnsemble);
        if (candidates.size() == 0) {
            throw new BKException.BKNotEnoughBookiesException();
        }
        return (InetSocketAddress)candidates.get(this.rand.nextInt(candidates.size()));
    }

    private void recoverLedger(final InetSocketAddress bookieSrc, final long lId, final AsyncCallback.VoidCallback ledgerIterCb, final List<InetSocketAddress> availableBookies) {
        LOG.debug("Recovering ledger : {}", (Object)lId);
        this.asyncOpenLedgerNoRecovery(lId, new AsyncCallback.OpenCallback(){

            @Override
            public void openComplete(int rc, LedgerHandle lh, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("BK error opening ledger: " + lId, (Throwable)BKException.create(rc));
                    ledgerIterCb.processResult(rc, null, null);
                    return;
                }
                LedgerMetadata lm = lh.getLedgerMetadata();
                if (!lm.isClosed() && lm.getEnsembles().size() > 0) {
                    Long lastKey = lm.getEnsembles().lastKey();
                    ArrayList lastEnsemble = (ArrayList)lm.getEnsembles().get(lastKey);
                    if (lastEnsemble.contains(bookieSrc)) {
                        try {
                            lh.close();
                        }
                        catch (Exception ie) {
                            LOG.warn("Error closing non recovery ledger handle for ledger " + lId, (Throwable)ie);
                        }
                        BookKeeperAdmin.this.asyncOpenLedger(lId, new AsyncCallback.OpenCallback(){

                            @Override
                            public void openComplete(int newrc, LedgerHandle newlh, Object newctx) {
                                if (newrc != KeeperException.Code.OK.intValue()) {
                                    LOG.error("BK error close ledger: " + lId, (Throwable)BKException.create(newrc));
                                    ledgerIterCb.processResult(newrc, null, null);
                                    return;
                                }
                                BookKeeperAdmin.this.recoverLedger(bookieSrc, lId, ledgerIterCb, availableBookies);
                            }
                        }, null);
                        return;
                    }
                }
                LinkedList<Long> ledgerFragmentsToRecover = new LinkedList<Long>();
                HashMap<Long, Long> ledgerFragmentsRange = new HashMap<Long, Long>();
                Long curEntryId = null;
                for (Map.Entry<Long, ArrayList<InetSocketAddress>> entry : lh.getLedgerMetadata().getEnsembles().entrySet()) {
                    if (curEntryId != null) {
                        ledgerFragmentsRange.put(curEntryId, entry.getKey() - 1L);
                    }
                    curEntryId = entry.getKey();
                    if (!entry.getValue().contains(bookieSrc)) continue;
                    ledgerFragmentsToRecover.add(entry.getKey());
                }
                if (curEntryId != null) {
                    ledgerFragmentsRange.put(curEntryId, lh.getLastAddConfirmed());
                }
                if (ledgerFragmentsToRecover.size() == 0) {
                    ledgerIterCb.processResult(0, null, null);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback ledgerFragmentsMcb = new BookkeeperInternalCallbacks.MultiCallback(ledgerFragmentsToRecover.size(), ledgerIterCb, null, 0, -10);
                for (Long startEntryId : ledgerFragmentsToRecover) {
                    Long endEntryId = (Long)ledgerFragmentsRange.get(startEntryId);
                    InetSocketAddress newBookie = null;
                    try {
                        newBookie = BookKeeperAdmin.this.getNewBookie((List)lh.getLedgerMetadata().getEnsembles().get(startEntryId), availableBookies);
                    }
                    catch (BKException.BKNotEnoughBookiesException bke) {
                        ledgerFragmentsMcb.processResult(-6, null, null);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Replicating fragment from [" + startEntryId + "," + endEntryId + "] of ledger " + lh.getId() + " to " + newBookie);
                    }
                    try {
                        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(ledgerFragmentsMcb, lh, startEntryId, bookieSrc, newBookie);
                        ArrayList<InetSocketAddress> currentEnsemble = lh.getLedgerMetadata().getEnsemble(startEntryId);
                        int bookieIndex = -1;
                        if (null != currentEnsemble) {
                            for (int i = 0; i < currentEnsemble.size(); ++i) {
                                if (!currentEnsemble.get(i).equals(bookieSrc)) continue;
                                bookieIndex = i;
                                break;
                            }
                        }
                        LedgerFragment ledgerFragment = new LedgerFragment(lh, startEntryId, endEntryId, bookieIndex);
                        BookKeeperAdmin.this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, newBookie);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }, null);
    }

    private void asyncRecoverLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, AsyncCallback.VoidCallback ledgerFragmentMcb, InetSocketAddress newBookie) throws InterruptedException {
        this.lfr.replicate(lh, ledgerFragment, ledgerFragmentMcb, newBookie);
    }

    public void replicateLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, InetSocketAddress targetBookieAddress) throws InterruptedException, BKException {
        SyncCounter syncCounter = new SyncCounter();
        ResultCallBack resultCallBack = new ResultCallBack(syncCounter);
        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(resultCallBack, lh, ledgerFragment.getFirstEntryId(), ledgerFragment.getAddress(), targetBookieAddress);
        syncCounter.inc();
        this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, targetBookieAddress);
        syncCounter.block(0);
        if (syncCounter.getrc() != 0) {
            throw BKException.create(syncCounter.getrc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean format(ClientConfiguration conf, boolean isInteractive, boolean force) throws Exception {
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(conf.getZkTimeout());
        ZooKeeper zkc = ZkUtils.createConnectedZookeeperClient(conf.getZkServers(), w);
        BookKeeper bkc = null;
        try {
            boolean availableNodeExists;
            boolean ledgerRootExists = null != zkc.exists(conf.getZkLedgersRootPath(), false);
            boolean bl = availableNodeExists = null != zkc.exists(conf.getZkAvailableBookiesPath(), false);
            if (!ledgerRootExists) {
                zkc.create(conf.getZkLedgersRootPath(), "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (!availableNodeExists) {
                zkc.create(conf.getZkAvailableBookiesPath(), "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (ledgerRootExists) {
                boolean confirm = false;
                confirm = !isInteractive ? force : IOUtils.confirmPrompt("Ledger root already exists. Are you sure to format bookkeeper metadata? This may cause data loss.");
                if (!confirm) {
                    LOG.error("BookKeeper metadata Format aborted!!");
                    boolean bl2 = false;
                    return bl2;
                }
            }
            bkc = new BookKeeper(conf, zkc);
            bkc.ledgerManagerFactory.format(conf, zkc);
            try {
                ZKUtil.deleteRecursive((ZooKeeper)zkc, (String)(conf.getZkLedgersRootPath() + "/cookies"));
            }
            catch (KeeperException.NoNodeException e) {
                LOG.debug("cookies node not exists in zookeeper to delete");
            }
            try {
                zkc.delete(conf.getZkLedgersRootPath() + "/" + "INSTANCEID", -1);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.debug("INSTANCEID not exists in zookeeper to delete");
            }
            String instanceId = UUID.randomUUID().toString();
            zkc.create(conf.getZkLedgersRootPath() + "/" + "INSTANCEID", instanceId.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Successfully formatted BookKeeper metadata");
        }
        finally {
            if (null != bkc) {
                bkc.close();
            }
            if (null != zkc) {
                zkc.close();
            }
        }
        return true;
    }

    public Iterable<Long> listLedgers() throws IOException {
        final LedgerManager.LedgerRangeIterator iterator = this.bkc.getLedgerManager().getLedgerRanges();
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    Iterator<Long> currentRange = null;

                    @Override
                    public boolean hasNext() {
                        try {
                            if (iterator.hasNext()) {
                                LOG.info("I'm in this part of");
                                return true;
                            }
                            if (this.currentRange != null && this.currentRange.hasNext()) {
                                return true;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while checking if there is a next element", (Throwable)e);
                        }
                        return false;
                    }

                    @Override
                    public Long next() throws NoSuchElementException {
                        try {
                            if (this.currentRange == null) {
                                this.currentRange = iterator.next().getLedgers().iterator();
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while reading the next element", (Throwable)e);
                            throw new NoSuchElementException(e.getMessage());
                        }
                        return this.currentRange.next();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public LedgerMetadata getLedgerMetadata(LedgerHandle lh) {
        return lh.getLedgerMetadata();
    }

    static class ResultCallBack
    implements AsyncCallback.VoidCallback {
        private SyncCounter sync;

        public ResultCallBack(SyncCounter sync) {
            this.sync = sync;
        }

        public void processResult(int rc, String s, Object obj) {
            this.sync.setrc(rc);
            this.sync.dec();
        }
    }

    static class SyncObject {
        boolean value = false;
        int rc = 0;
    }
}

