/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.NavigableMap;
import java.util.Set;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanAndCompareGarbageCollector
implements GarbageCollector {
    static final Logger LOG = LoggerFactory.getLogger(ScanAndCompareGarbageCollector.class);
    private SnapshotMap<Long, Boolean> activeLedgers;
    private LedgerManager ledgerManager;

    public ScanAndCompareGarbageCollector(LedgerManager ledgerManager, SnapshotMap<Long, Boolean> activeLedgers) {
        this.ledgerManager = ledgerManager;
        this.activeLedgers = activeLedgers;
    }

    @Override
    public void gc(GarbageCollector.GarbageCleaner garbageCleaner) {
        NavigableMap<Long, Boolean> bkActiveLedgersSnapshot = this.activeLedgers.snapshot();
        LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.ledgerManager.getLedgerRanges();
        try {
            if (!ledgerRangeIterator.hasNext()) {
                for (Long bkLid : bkActiveLedgersSnapshot.keySet()) {
                    bkActiveLedgersSnapshot.remove(bkLid);
                    garbageCleaner.clean(bkLid);
                }
            }
            long lastEnd = -1L;
            while (ledgerRangeIterator.hasNext()) {
                LedgerManager.LedgerRange lRange = ledgerRangeIterator.next();
                NavigableMap<Long, Boolean> subBkActiveLedgers = null;
                Long start = lastEnd + 1L;
                Long end = lRange.end();
                if (!ledgerRangeIterator.hasNext()) {
                    end = Long.MAX_VALUE;
                }
                subBkActiveLedgers = bkActiveLedgersSnapshot.subMap(start, true, end, true);
                Set<Long> ledgersInMetadata = lRange.getLedgers();
                LOG.debug("Active in metadata {}, Active in bookie {}", ledgersInMetadata, subBkActiveLedgers.keySet());
                for (Long bkLid : subBkActiveLedgers.keySet()) {
                    if (ledgersInMetadata.contains(bkLid)) continue;
                    subBkActiveLedgers.remove(bkLid);
                    garbageCleaner.clean(bkLid);
                }
                lastEnd = end;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when iterating over the metadata {}", (Throwable)e);
        }
    }
}

