/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.RandomData;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.compiler.specific.TestSpecificCompiler;
import org.apache.avro.data.Json;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;

public class TestSchema {
    public static final String LISP_SCHEMA = "{\"type\": \"record\", \"name\": \"Lisp\", \"fields\": [{\"name\":\"value\", \"type\":[\"null\", \"string\",{\"type\": \"record\", \"name\": \"Cons\", \"fields\": [{\"name\":\"car\", \"type\":\"Lisp\"},{\"name\":\"cdr\", \"type\":\"Lisp\"}]}]}]}";
    public static final String BASIC_ENUM_SCHEMA = "{\"type\":\"enum\", \"name\":\"Test\",\"symbols\": [\"A\", \"B\"]}";
    public static final String SCHEMA_WITH_DOC_TAGS = "{\n  \"type\": \"record\",\n  \"name\": \"outer_record\",\n  \"doc\": \"This is not a world record.\",\n  \"fields\": [\n    { \"type\": { \"type\": \"fixed\", \"doc\": \"Very Inner Fixed\",                   \"name\": \"very_inner_fixed\", \"size\": 1 },\n      \"doc\": \"Inner Fixed\", \"name\": \"inner_fixed\" },\n    { \"type\": \"string\",\n      \"name\": \"inner_string\",\n      \"doc\": \"Inner String\" },\n    { \"type\": { \"type\": \"enum\", \"doc\": \"Very Inner Enum\", \n                  \"name\": \"very_inner_enum\", \n                  \"symbols\": [ \"A\", \"B\", \"C\" ] },\n      \"doc\": \"Inner Enum\", \"name\": \"inner_enum\" },\n    { \"type\": [\"string\", \"int\"], \"doc\": \"Inner Union\", \n      \"name\": \"inner_union\" }\n  ]\n}\n";
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "30"));
    private static final Schema ACTUAL = Schema.parse((String)"{\"type\":\"record\", \"name\":\"Foo\", \"fields\":[]}");

    @Test
    public void testNull() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.NULL), (Object)Schema.parse((String)"\"null\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.NULL), (Object)Schema.parse((String)"{\"type\":\"null\"}"));
        TestSchema.check("\"null\"", "null", null);
    }

    @Test
    public void testBoolean() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.BOOLEAN), (Object)Schema.parse((String)"\"boolean\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.BOOLEAN), (Object)Schema.parse((String)"{\"type\":\"boolean\"}"));
        TestSchema.check("\"boolean\"", "true", Boolean.TRUE);
    }

    @Test
    public void testString() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.STRING), (Object)Schema.parse((String)"\"string\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.STRING), (Object)Schema.parse((String)"{\"type\":\"string\"}"));
        TestSchema.check("\"string\"", "\"foo\"", new Utf8("foo"));
    }

    @Test
    public void testBytes() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.BYTES), (Object)Schema.parse((String)"\"bytes\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.BYTES), (Object)Schema.parse((String)"{\"type\":\"bytes\"}"));
        TestSchema.check("\"bytes\"", "\"\\u0000ABC\\u00FF\"", ByteBuffer.wrap(new byte[]{0, 65, 66, 67, -1}));
    }

    @Test
    public void testInt() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.INT), (Object)Schema.parse((String)"\"int\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.INT), (Object)Schema.parse((String)"{\"type\":\"int\"}"));
        TestSchema.check("\"int\"", "9", new Integer(9));
    }

    @Test
    public void testLong() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.LONG), (Object)Schema.parse((String)"\"long\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.LONG), (Object)Schema.parse((String)"{\"type\":\"long\"}"));
        TestSchema.check("\"long\"", "11", new Long(11L));
    }

    @Test
    public void testFloat() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.FLOAT), (Object)Schema.parse((String)"\"float\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.FLOAT), (Object)Schema.parse((String)"{\"type\":\"float\"}"));
        TestSchema.check("\"float\"", "1.1", new Float(1.1));
        TestSchema.checkDefault("\"float\"", "\"NaN\"", Float.valueOf(Float.NaN));
        TestSchema.checkDefault("\"float\"", "\"Infinity\"", Float.valueOf(Float.POSITIVE_INFINITY));
        TestSchema.checkDefault("\"float\"", "\"-Infinity\"", Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testDouble() throws Exception {
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.DOUBLE), (Object)Schema.parse((String)"\"double\""));
        Assert.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.DOUBLE), (Object)Schema.parse((String)"{\"type\":\"double\"}"));
        TestSchema.check("\"double\"", "1.2", new Double(1.2));
        TestSchema.checkDefault("\"double\"", "\"NaN\"", Double.NaN);
        TestSchema.checkDefault("\"double\"", "\"Infinity\"", Double.POSITIVE_INFINITY);
        TestSchema.checkDefault("\"double\"", "\"-Infinity\"", Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testArray() throws Exception {
        String json = "{\"type\":\"array\", \"items\": \"long\"}";
        Schema schema = Schema.parse((String)json);
        Object array = new GenericData.Array(1, schema);
        array.add(1L);
        TestSchema.check(json, "[1]", array);
        array = new ArrayList(1);
        array.add(1L);
        TestSchema.check(json, "[1]", array);
        TestSchema.checkParseError("{\"type\":\"array\"}");
    }

    @Test
    public void testMap() throws Exception {
        HashMap<Utf8, Long> map = new HashMap<Utf8, Long>();
        map.put(new Utf8("a"), 1L);
        TestSchema.check("{\"type\":\"map\", \"values\":\"long\"}", "{\"a\":1}", map);
        TestSchema.checkParseError("{\"type\":\"map\"}");
    }

    @Test
    public void testUnionMap() throws Exception {
        String unionMapSchema = "{\"name\":\"foo\", \"type\":\"record\", \"fields\":[ {\"name\":\"mymap\", \"type\":   [{\"type\":\"map\", \"values\":      [\"int\",\"long\",\"float\",\"string\"]},    \"null\"]   }] }";
        TestSchema.check(unionMapSchema, true);
    }

    @Test
    public void testRecord() throws Exception {
        String recordJson = "{\"type\":\"record\", \"name\":\"Test\", \"fields\":[{\"name\":\"f\", \"type\":\"long\", \"foo\":\"bar\"}]}";
        Schema schema = Schema.parse((String)recordJson);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", (Object)11L);
        TestSchema.check(recordJson, "{\"f\":11}", record, false);
        Assert.assertEquals((Object)"bar", (Object)schema.getField("f").getProp("foo"));
        Assert.assertEquals((Object)"bar", (Object)Schema.parse((String)schema.toString()).getField("f").getProp("foo"));
        schema.getField("f").addProp("baz", "boo");
        Assert.assertEquals((Object)"boo", (Object)schema.getField("f").getProp("baz"));
        TestSchema.checkParseError("{\"type\":\"record\"}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\"}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":\"Y\"}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"name\":\"f\"}]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"type\":\"long\"}]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"1X\",\"fields\":[]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X$\",\"fields\":[]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"name\":\"1f\",\"type\":\"int\"}]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"name\":\"f$\",\"type\":\"int\"}]}");
        TestSchema.checkParseError("{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"name\":\"f.g\",\"type\":\"int\"}]}");
    }

    @Test
    public void testInvalidNameTolerance() {
        Schema.parse((String)"{\"type\":\"record\",\"name\":\"1X\",\"fields\":[]}", (boolean)false);
        Schema.parse((String)"{\"type\":\"record\",\"name\":\"X-\",\"fields\":[]}", (boolean)false);
        Schema.parse((String)"{\"type\":\"record\",\"name\":\"X$\",\"fields\":[]}", (boolean)false);
    }

    @Test
    public void testMapInRecord() throws Exception {
        String json = "{\"type\":\"record\", \"name\":\"Test\", \"fields\":[{\"name\":\"f\", \"type\": {\"type\":\"map\", \"values\":\"long\"}}]}";
        Schema schema = Schema.parse((String)json);
        HashMap<Utf8, Long> map = new HashMap<Utf8, Long>();
        map.put(new Utf8("a"), 1L);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", map);
        TestSchema.check(json, "{\"f\":{\"a\":1}}", record, false);
    }

    @Test
    public void testEnum() throws Exception {
        TestSchema.check(BASIC_ENUM_SCHEMA, "\"B\"", new GenericData.EnumSymbol(Schema.parse((String)BASIC_ENUM_SCHEMA), "B"), false);
        TestSchema.checkParseError("{\"type\":\"enum\"}");
        TestSchema.checkParseError("{\"type\":\"enum\",\"symbols\": [\"X\"]}");
        TestSchema.checkParseError("{\"type\":\"enum\",\"name\":\"X\",\"symbols\":[\"X\",\"X\"]}");
        TestSchema.checkParseError("{\"type\":\"enum\",\"name\":\"X\",\"symbols\":[\"1X\"]}");
        TestSchema.checkParseError("{\"type\":\"enum\",\"name\":\"X\",\"symbols\":[\"X$\"]}");
        TestSchema.checkParseError("{\"type\":\"enum\",\"name\":\"X\",\"symbols\":[\"X.Y\"]}");
    }

    @Test
    public void testFixed() throws Exception {
        String json = "{\"type\": \"fixed\", \"name\":\"Test\", \"size\": 1}";
        Schema schema = Schema.parse((String)json);
        TestSchema.check(json, "\"a\"", new GenericData.Fixed(schema, new byte[]{97}), false);
        TestSchema.checkParseError("{\"type\":\"fixed\"}");
    }

    @Test
    public void testRecursive() throws Exception {
        TestSchema.check("{\"type\": \"record\", \"name\": \"Node\", \"fields\": [{\"name\":\"label\", \"type\":\"string\"},{\"name\":\"children\", \"type\":{\"type\": \"array\", \"items\": \"Node\" }}]}", false);
    }

    @Test
    public void testRecursiveEquals() throws Exception {
        String jsonSchema = "{\"type\":\"record\", \"name\":\"List\", \"fields\": [{\"name\":\"next\", \"type\":\"List\"}]}";
        Schema s1 = Schema.parse((String)jsonSchema);
        Schema s2 = Schema.parse((String)jsonSchema);
        Assert.assertEquals((Object)s1, (Object)s2);
        s1.hashCode();
    }

    @Test
    public void testSchemaExplosion() throws Exception {
        for (int i = 1; i < 15; ++i) {
            ArrayList<Schema> recs = new ArrayList<Schema>();
            for (int j = 0; j < i; ++j) {
                recs.add(Schema.createRecord((String)("" + (char)(65 + j)), null, null, (boolean)false));
            }
            for (Schema s : recs) {
                Schema union = Schema.createUnion(recs);
                Schema.Field f = new Schema.Field("x", union, null, null);
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                fields.add(f);
                s.setFields(fields);
            }
            for (Schema s1 : recs) {
                Schema s2 = Schema.parse((String)s1.toString());
                Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
                Assert.assertEquals((Object)s1, (Object)s2);
            }
        }
    }

    @Test
    public void testLisp() throws Exception {
        TestSchema.check(LISP_SCHEMA, false);
    }

    @Test
    public void testUnion() throws Exception {
        TestSchema.check("[\"string\", \"long\"]", false);
        TestSchema.checkDefault("[\"double\", \"long\"]", "1.1", new Double(1.1));
        for (String type : new String[]{"int", "long", "float", "double", "string", "bytes", "boolean"}) {
            boolean error = false;
            try {
                TestSchema.checkDefault("[\"" + type + "\", \"null\"]", "null", 0);
            }
            catch (AvroTypeException e) {
                error = true;
            }
            Assert.assertTrue((boolean)error);
            error = false;
            try {
                TestSchema.checkDefault("[\"null\", \"" + type + "\"]", "0", null);
            }
            catch (AvroTypeException e) {
                error = true;
            }
            Assert.assertTrue((boolean)error);
        }
        String record = "{\"type\":\"record\",\"name\":\"Foo\",\"fields\":[]}";
        String fixed = "{\"type\":\"fixed\",\"name\":\"Bar\",\"size\": 1}";
        String enu = "{\"type\":\"enum\",\"name\":\"Baz\",\"symbols\": [\"X\"]}";
        Schema union = Schema.parse((String)("[\"null\",\"string\"," + record + "," + enu + "," + fixed + "]"));
        TestSchema.checkJson(union, null, "null");
        TestSchema.checkJson(union, new Utf8("foo"), "{\"string\":\"foo\"}");
        TestSchema.checkJson(union, new GenericData.Record(Schema.parse((String)record)), "{\"Foo\":{}}");
        TestSchema.checkJson(union, new GenericData.Fixed(Schema.parse((String)fixed), new byte[]{97}), "{\"Bar\":\"a\"}");
        TestSchema.checkJson(union, new GenericData.EnumSymbol(Schema.parse((String)enu), "X"), "{\"Baz\":\"X\"}");
    }

    @Test
    public void testComplexUnions() throws Exception {
        String partial = "[\"int\", \"long\", \"float\", \"double\", \"boolean\", \"bytes\", \"string\", {\"type\":\"array\", \"items\": \"long\"}, {\"type\":\"map\", \"values\":\"long\"}";
        String namedTypes = ", {\"type\":\"record\",\"name\":\"Foo\",\"fields\":[]}, {\"type\":\"fixed\",\"name\":\"Bar\",\"size\": 1}, {\"type\":\"enum\",\"name\":\"Baz\",\"symbols\": [\"X\"]}";
        String namedTypes2 = ", {\"type\":\"record\",\"name\":\"Foo2\",\"fields\":[]}, {\"type\":\"fixed\",\"name\":\"Bar2\",\"size\": 1}, {\"type\":\"enum\",\"name\":\"Baz2\",\"symbols\": [\"X\"]}";
        TestSchema.check(partial + namedTypes + "]", false);
        TestSchema.check(partial + namedTypes + namedTypes2 + "]", false);
        TestSchema.checkParseError(partial + namedTypes + namedTypes + "]");
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.INT)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.LONG)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.FLOAT)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.DOUBLE)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.BOOLEAN)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.BYTES), Schema.create((Schema.Type)Schema.Type.BYTES)});
        TestSchema.checkUnionError(new Schema[]{Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.STRING)});
        TestSchema.checkUnionError(new Schema[]{Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))});
        TestSchema.checkUnionError(new Schema[]{Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.INT)), Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.INT))});
        ArrayList<String> symbols = new ArrayList<String>();
        symbols.add("NOTHING");
        Schema u = TestSchema.buildUnion(new Schema[]{Schema.parse((String)"{\"type\":\"record\",\"name\":\"x.A\",\"fields\":[]}"), Schema.parse((String)"{\"type\":\"record\",\"name\":\"y.A\",\"fields\":[]}")});
        TestSchema.check(u.toString(), false);
        u = TestSchema.buildUnion(new Schema[]{Schema.parse((String)"{\"type\":\"enum\",\"name\":\"x.A\",\"symbols\":[\"X\"]}"), Schema.parse((String)"{\"type\":\"enum\",\"name\":\"y.A\",\"symbols\":[\"Y\"]}")});
        TestSchema.check(u.toString(), false);
        u = TestSchema.buildUnion(new Schema[]{Schema.parse((String)"{\"type\":\"fixed\",\"name\":\"x.A\",\"size\":4}"), Schema.parse((String)"{\"type\":\"fixed\",\"name\":\"y.A\",\"size\":8}")});
        TestSchema.check(u.toString(), false);
        TestSchema.checkUnionError(new Schema[]{Schema.createRecord((String)"Foo", null, (String)"org.test", (boolean)false), Schema.createRecord((String)"Foo", null, (String)"org.test", (boolean)false)});
        TestSchema.checkUnionError(new Schema[]{Schema.createEnum((String)"Bar", null, (String)"org.test", symbols), Schema.createEnum((String)"Bar", null, (String)"org.test", symbols)});
        TestSchema.checkUnionError(new Schema[]{Schema.createFixed((String)"Baz", null, (String)"org.test", (int)2), Schema.createFixed((String)"Baz", null, (String)"org.test", (int)1)});
        Schema union = TestSchema.buildUnion(new Schema[]{Schema.create((Schema.Type)Schema.Type.INT)});
        TestSchema.checkUnionError(new Schema[]{union});
    }

    @Test
    public void testComplexProp() throws Exception {
        String json = "{\"type\":\"null\", \"foo\": [0]}";
        Schema s = Schema.parse((String)json);
        Assert.assertEquals(null, (Object)s.getProp("foo"));
    }

    @Test
    public void testPropOrdering() throws Exception {
        String json = "{\"type\":\"int\",\"z\":\"c\",\"yy\":\"b\",\"x\":\"a\"}";
        Schema s = Schema.parse((String)json);
        Assert.assertEquals((Object)json, (Object)s.toString());
    }

    @Test
    public void testParseInputStream() throws IOException {
        Schema s = Schema.parse((InputStream)new ByteArrayInputStream("\"boolean\"".getBytes("UTF-8")));
        Assert.assertEquals((Object)Schema.parse((String)"\"boolean\""), (Object)s);
    }

    @Test
    public void testNamespaceScope() throws Exception {
        String z = "{\"type\":\"record\",\"name\":\"Z\",\"fields\":[]}";
        String y = "{\"type\":\"record\",\"name\":\"q.Y\",\"fields\":[{\"name\":\"f\",\"type\":" + z + "}]}";
        String x = "{\"type\":\"record\",\"name\":\"p.X\",\"fields\":[{\"name\":\"f\",\"type\":" + y + "}," + "{\"name\":\"g\",\"type\":" + z + "}" + "]}";
        Schema xs = Schema.parse((String)x);
        Schema ys = xs.getField("f").schema();
        Assert.assertEquals((Object)"p.Z", (Object)xs.getField("g").schema().getFullName());
        Assert.assertEquals((Object)"q.Z", (Object)ys.getField("f").schema().getFullName());
    }

    @Test
    public void testNamespaceNesting() throws Exception {
        String y = "{\"type\":\"record\",\"name\":\"y.Y\",\"fields\":[{\"name\":\"f\",\"type\":\"x.X\"}]}";
        String x = "{\"type\":\"record\",\"name\":\"x.X\",\"fields\":[{\"name\":\"f\",\"type\":" + y + "}" + "]}";
        Schema xs = Schema.parse((String)x);
        Assert.assertEquals((Object)xs, (Object)Schema.parse((String)xs.toString()));
    }

    @Test
    public void testNestedNullNamespace() throws Exception {
        Schema inner = Schema.parse((String)"{\"type\":\"record\",\"name\":\"Inner\",\"fields\":[]}");
        Schema outer = Schema.createRecord((String)"Outer", null, (String)"space", (boolean)false);
        outer.setFields(Arrays.asList(new Schema.Field("f", inner, null, null)));
        Assert.assertEquals((Object)outer, (Object)Schema.parse((String)outer.toString()));
    }

    @Test
    public void testNullPointer() throws Exception {
        String recordJson = "{\"type\":\"record\", \"name\":\"Test\", \"fields\":[{\"name\":\"x\", \"type\":\"string\"}]}";
        Schema schema = Schema.parse((String)recordJson);
        GenericData.Record record = new GenericData.Record(schema);
        try {
            TestSchema.checkBinary(schema, record, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader());
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"null of string in field x of Test", (Object)e.getMessage());
        }
    }

    private static void checkParseError(String json) {
        try {
            Schema.parse((String)json);
        }
        catch (SchemaParseException e) {
            return;
        }
        Assert.fail((String)("Should not have parsed: " + json));
    }

    private static void checkUnionError(Schema[] branches) {
        List<Schema> branchList = Arrays.asList(branches);
        try {
            Schema.createUnion(branchList);
            Assert.fail((String)("Union should not have constructed from: " + branchList));
        }
        catch (AvroRuntimeException are) {
            return;
        }
    }

    private static Schema buildUnion(Schema[] branches) {
        List<Schema> branchList = Arrays.asList(branches);
        return Schema.createUnion(branchList);
    }

    @Test
    public void testDocs() {
        Schema schema = Schema.parse((String)SCHEMA_WITH_DOC_TAGS);
        Assert.assertEquals((Object)"This is not a world record.", (Object)schema.getDoc());
        Assert.assertEquals((Object)"Inner Fixed", (Object)schema.getField("inner_fixed").doc());
        Assert.assertEquals((Object)"Very Inner Fixed", (Object)schema.getField("inner_fixed").schema().getDoc());
        Assert.assertEquals((Object)"Inner String", (Object)schema.getField("inner_string").doc());
        Assert.assertEquals((Object)"Inner Enum", (Object)schema.getField("inner_enum").doc());
        Assert.assertEquals((Object)"Very Inner Enum", (Object)schema.getField("inner_enum").schema().getDoc());
        Assert.assertEquals((Object)"Inner Union", (Object)schema.getField("inner_union").doc());
    }

    @Test
    public void testFieldDocs() {
        String schemaStr = "{\"name\": \"Rec\",\"type\": \"record\",\"fields\" : [{\"name\": \"f\", \"type\": \"int\", \"doc\": \"test\"}]}";
        Schema schema = Schema.parse((String)schemaStr);
        Assert.assertEquals((Object)"test", (Object)schema.getField("f").doc());
        schema = Schema.parse((String)schema.toString());
        Assert.assertEquals((Object)"test", (Object)schema.getField("f").doc());
    }

    @Test
    public void testAliases() throws Exception {
        String t1 = "{\"type\":\"record\",\"name\":\"a.b\",\"fields\":[{\"name\":\"f\",\"type\":\"long\"},{\"name\":\"h\",\"type\":\"int\"}]}";
        String t2 = "{\"type\":\"record\",\"name\":\"x.y\",\"aliases\":[\"a.b\"],\"fields\":[{\"name\":\"g\",\"type\":\"long\",\"aliases\":[\"f\"]},{\"name\":\"h\",\"type\":\"int\"}]}";
        Schema s1 = Schema.parse((String)t1);
        Schema s2 = Schema.parse((String)t2);
        Assert.assertEquals((Object)s1.getAliases(), Collections.emptySet());
        Assert.assertEquals((Object)s1.getField("f").aliases(), Collections.emptySet());
        Assert.assertEquals((Object)s2.getAliases(), Collections.singleton("a.b"));
        Assert.assertEquals((Object)s2.getField("g").aliases(), Collections.singleton("f"));
        Schema s3 = Schema.applyAliases((Schema)s1, (Schema)s2);
        Assert.assertFalse((s2 == s3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)s2, (Object)s3);
        t1 = "{\"type\":\"enum\",\"name\":\"a.b\",\"symbols\":[\"x\"]}";
        t2 = "{\"type\":\"enum\",\"name\":\"a.c\",\"aliases\":[\"b\"],\"symbols\":[\"x\"]}";
        s1 = Schema.parse((String)t1);
        s2 = Schema.parse((String)t2);
        s3 = Schema.applyAliases((Schema)s1, (Schema)s2);
        Assert.assertFalse((s2 == s3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)s2, (Object)s3);
        t1 = "{\"type\":\"fixed\",\"name\":\"a\",\"size\": 5}";
        t2 = "{\"type\":\"fixed\",\"name\":\"b\",\"aliases\":[\"a\"],\"size\": 5}";
        s1 = Schema.parse((String)t1);
        s2 = Schema.parse((String)t2);
        s3 = Schema.applyAliases((Schema)s1, (Schema)s2);
        Assert.assertFalse((s2 == s3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)s2, (Object)s3);
    }

    private static void check(String schemaJson, String defaultJson, Object defaultValue) throws Exception {
        TestSchema.check(schemaJson, defaultJson, defaultValue, true);
    }

    private static void check(String schemaJson, String defaultJson, Object defaultValue, boolean induce) throws Exception {
        TestSchema.check(schemaJson, induce);
        TestSchema.checkDefault(schemaJson, defaultJson, defaultValue);
    }

    private static void check(String jsonSchema, boolean induce) throws Exception {
        Schema schema = Schema.parse((String)jsonSchema);
        TestSchema.checkProp(schema);
        Object reuse = null;
        for (Object datum : new RandomData(schema, COUNT)) {
            if (induce) {
                Schema induced = GenericData.get().induce(datum);
                Assert.assertEquals((String)"Induced schema does not match.", (Object)schema, (Object)induced);
            }
            Assert.assertTrue((String)("Datum does not validate against schema " + datum), (boolean)GenericData.get().validate(schema, datum));
            TestSchema.checkBinary(schema, datum, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader(), null);
            reuse = TestSchema.checkBinary(schema, datum, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader(), reuse);
            TestSchema.checkDirectBinary(schema, datum, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader());
            TestSchema.checkBlockingBinary(schema, datum, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader());
            TestSchema.checkJson(schema, datum, (DatumWriter<Object>)new GenericDatumWriter(), (DatumReader<Object>)new GenericDatumReader());
            TestSpecificCompiler.assertCompiles(schema, false);
            TestSchema.checkBinaryJson(jsonSchema);
        }
    }

    private static void checkProp(Schema s0) throws Exception {
        if (s0.getType().equals((Object)Schema.Type.UNION)) {
            return;
        }
        Assert.assertEquals(null, (Object)s0.getProp("foo"));
        Schema s1 = Schema.parse((String)s0.toString());
        s1.addProp("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)s1.getProp("foo"));
        Assert.assertFalse((boolean)s0.equals((Object)s1));
        Schema s2 = Schema.parse((String)s1.toString());
        Assert.assertEquals((Object)"bar", (Object)s2.getProp("foo"));
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertFalse((boolean)s0.equals((Object)s2));
    }

    public static void checkBinary(Schema schema, Object datum, DatumWriter<Object> writer, DatumReader<Object> reader) throws IOException {
        TestSchema.checkBinary(schema, datum, writer, reader, null);
    }

    public static Object checkBinary(Schema schema, Object datum, DatumWriter<Object> writer, DatumReader<Object> reader, Object reuse) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setSchema(schema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        byte[] data = out.toByteArray();
        reader.setSchema(schema);
        Object decoded = reader.read(reuse, (Decoder)DecoderFactory.get().binaryDecoder(data, null));
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
        return decoded;
    }

    public static void checkDirectBinary(Schema schema, Object datum, DatumWriter<Object> writer, DatumReader<Object> reader) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setSchema(schema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        writer.write(datum, (Encoder)encoder);
        byte[] data = out.toByteArray();
        reader.setSchema(schema);
        Object decoded = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(data, null));
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
    }

    public static void checkBlockingBinary(Schema schema, Object datum, DatumWriter<Object> writer, DatumReader<Object> reader) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setSchema(schema);
        BinaryEncoder encoder = EncoderFactory.get().blockingBinaryEncoder((OutputStream)out, null);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        byte[] data = out.toByteArray();
        reader.setSchema(schema);
        Object decoded = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(data, null));
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
    }

    private static void checkJson(Schema schema, Object datum, DatumWriter<Object> writer, DatumReader<Object> reader) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        writer.setSchema(schema);
        writer.write(datum, (Encoder)encoder);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        byte[] data = out.toByteArray();
        reader.setSchema(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)new ByteArrayInputStream(data));
        Object decoded = reader.read(null, (Decoder)decoder);
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
        decoded = reader.read(decoded, (Decoder)decoder);
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
    }

    private static void checkJson(Schema schema, Object datum, String json) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        GenericDatumWriter writer = new GenericDatumWriter();
        writer.setSchema(schema);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        byte[] data = out.toByteArray();
        String encoded = new String(data, "UTF-8");
        Assert.assertEquals((String)"Encoded data does not match.", (Object)json, (Object)encoded);
        GenericDatumReader reader = new GenericDatumReader();
        reader.setSchema(schema);
        Object decoded = reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, (InputStream)new ByteArrayInputStream(data)));
        Assert.assertEquals((String)"Decoded data does not match.", (Object)datum, (Object)decoded);
    }

    public static void checkBinaryJson(String json) throws Exception {
        JsonNode node = Schema.parseJson((String)json);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Json.Writer writer = new Json.Writer();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        encoder = EncoderFactory.get().validatingEncoder(Json.SCHEMA, (Encoder)encoder);
        writer.write((Object)node, (Encoder)encoder);
        encoder.flush();
        byte[] bytes = out.toByteArray();
        Json.Reader reader = new Json.Reader();
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
        decoder = DecoderFactory.get().validatingDecoder(Json.SCHEMA, (Decoder)decoder);
        JsonNode decoded = (JsonNode)reader.read(null, (Decoder)decoder);
        Assert.assertEquals((String)"Decoded json does not match.", (Object)node.toString(), (Object)decoded.toString());
    }

    private static void checkDefault(String schemaJson, String defaultJson, Object defaultValue) throws Exception {
        String recordJson = "{\"type\":\"record\", \"name\":\"Foo\", \"fields\":[{\"name\":\"f\", \"type\":" + schemaJson + ", " + "\"default\":" + defaultJson + "}]}";
        Schema expected = Schema.parse((String)recordJson);
        GenericDatumReader in = new GenericDatumReader(ACTUAL, expected);
        GenericData.Record record = (GenericData.Record)in.read(null, (Decoder)DecoderFactory.get().binaryDecoder(new byte[0], null));
        Assert.assertEquals((String)"Wrong default.", (Object)defaultValue, (Object)record.get("f"));
        Assert.assertEquals((String)"Wrong toString", (Object)expected, (Object)Schema.parse((String)expected.toString()));
    }

    @Test(expected=AvroTypeException.class)
    public void testNoDefaultField() throws Exception {
        Schema expected = Schema.parse((String)"{\"type\":\"record\", \"name\":\"Foo\", \"fields\":[{\"name\":\"f\", \"type\": \"string\"}]}");
        GenericDatumReader in = new GenericDatumReader(ACTUAL, expected);
        in.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(new byte[0]), null));
    }

    @Test
    public void testEnumMismatch() throws Exception {
        Schema actual = Schema.parse((String)"{\"type\":\"enum\",\"name\":\"E\",\"symbols\":[\"X\",\"Y\"]}");
        Schema expected = Schema.parse((String)"{\"type\":\"enum\",\"name\":\"E\",\"symbols\":[\"Y\",\"Z\"]}");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(actual);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        writer.write((Object)new GenericData.EnumSymbol(actual, "Y"), (Encoder)encoder);
        writer.write((Object)new GenericData.EnumSymbol(actual, "X"), (Encoder)encoder);
        encoder.flush();
        byte[] data = out.toByteArray();
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
        GenericDatumReader in = new GenericDatumReader(actual, expected);
        Assert.assertEquals((String)"Wrong value", (Object)new GenericData.EnumSymbol(expected, "Y"), (Object)in.read(null, (Decoder)decoder));
        try {
            in.read(null, (Decoder)decoder);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (AvroTypeException e) {
            // empty catch block
        }
    }

    @Test(expected=AvroTypeException.class)
    public void testRecordWithPrimitiveName() {
        Schema.parse((String)"{\"type\":\"record\", \"name\":\"string\", \"fields\": []}");
    }

    @Test(expected=AvroTypeException.class)
    public void testEnumWithPrimitiveName() {
        Schema.parse((String)"{\"type\":\"enum\", \"name\":\"null\", \"symbols\": [\"A\"]}");
    }

    private static Schema enumSchema() {
        return Schema.parse((String)"{ \"type\": \"enum\", \"name\": \"e\", \"symbols\": [\"a\", \"b\"]}");
    }

    @Test(expected=AvroRuntimeException.class)
    public void testImmutability1() {
        Schema s = TestSchema.enumSchema();
        s.addProp("p1", "1");
        s.addProp("p1", "2");
    }

    @Test(expected=AvroRuntimeException.class)
    public void testImmutability2() {
        Schema s = TestSchema.enumSchema();
        s.addProp("p1", (String)null);
    }

    private static List<String> lockedArrayList() {
        return new Schema.LockableArrayList(Arrays.asList("a", "b", "c")).lock();
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList1() {
        TestSchema.lockedArrayList().add("p");
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList2() {
        TestSchema.lockedArrayList().remove("a");
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList3() {
        TestSchema.lockedArrayList().addAll(Arrays.asList("p"));
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList4() {
        TestSchema.lockedArrayList().addAll(0, Arrays.asList("p"));
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList5() {
        TestSchema.lockedArrayList().removeAll(Arrays.asList("a"));
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList6() {
        TestSchema.lockedArrayList().retainAll(Arrays.asList("a"));
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList7() {
        TestSchema.lockedArrayList().clear();
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList8() {
        TestSchema.lockedArrayList().iterator().remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList9() {
        Iterator<String> it = TestSchema.lockedArrayList().iterator();
        it.next();
        it.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testLockedArrayList10() {
        TestSchema.lockedArrayList().remove(1);
    }
}

