/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

class CleanUpBulkImport
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CleanUpBulkImport.class);
    private String tableId;
    private String source;
    private String bulk;
    private String error;

    public CleanUpBulkImport(String tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.debug((Object)("removing the bulk processing flag file in " + this.bulk));
        Path bulkDir = new Path(this.bulk);
        MetadataTable.removeBulkLoadInProgressFlag("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName());
        MetadataTable.addDeleteEntry(this.tableId, "/" + bulkDir.getName());
        log.debug((Object)"removing the metadata table markers for loaded files");
        Connector conn = master.getConnector();
        MetadataTable.removeBulkLoadEntries(conn, this.tableId, tid);
        log.debug((Object)("releasing HDFS reservations for " + this.source + " and " + this.error));
        Utils.unreserveHdfsDirectory(this.source, tid);
        Utils.unreserveHdfsDirectory(this.error, tid);
        Utils.getReadLock(this.tableId, tid).unlock();
        log.debug((Object)("completing bulk import transaction " + tid));
        TransactionWatcher.ZooArbitrator.cleanup("bulkTx", tid);
        return null;
    }
}

