/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.strategy.SelfFirstStrategy;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.FileUtils;
import scala_maven.ScalaMojoSupport;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.MainHelper;

public class ScalaScriptMojo
extends ScalaMojoSupport {
    protected File outputDir;
    protected File scriptFile;
    protected String script;
    protected boolean keepGeneratedScript;
    protected String includeScopes;
    protected String excludeScopes;
    protected String addToClasspath;
    protected String removeFromClasspath;
    private static AtomicInteger _lastScriptIndex = new AtomicInteger(0);

    private static String scriptBaseNameOf(File scriptFile, int idx) {
        if (scriptFile == null) {
            return "embeddedScript_" + idx;
        }
        int dot = scriptFile.getName().lastIndexOf(46);
        if (dot == -1) {
            return scriptFile.getName() + "_" + idx;
        }
        return scriptFile.getName().substring(0, dot) + "_" + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("Either script or scriptFile must be defined");
        }
        if (this.script != null && this.scriptFile != null) {
            throw new MojoFailureException("Only one of script or scriptFile can be defined");
        }
        if (StringUtils.isEmpty((String)this.includeScopes)) {
            this.includeScopes = this.scriptFile != null ? "compile, test, runtime" : "plugin";
        }
        if (this.excludeScopes == null) {
            this.excludeScopes = "";
        }
        File scriptDir = new File(this.outputDir, ".scalaScriptGen");
        scriptDir.mkdirs();
        String baseName = ScalaScriptMojo.scriptBaseNameOf(this.scriptFile, _lastScriptIndex.incrementAndGet());
        File destFile = new File(scriptDir, baseName + ".scala");
        HashSet<String> classpath = new HashSet<String>();
        this.configureClasspath(classpath);
        boolean mavenProjectDependency = this.includeScopes.contains("plugin");
        this.wrapScript(destFile, mavenProjectDependency);
        try {
            URLClassLoader loader = this.createScriptClassloader(scriptDir, classpath);
            this.getLog().debug((CharSequence)("classpath : " + Arrays.asList(loader.getURLs())));
            this.compileScript(scriptDir, destFile, loader);
            this.runScript(mavenProjectDependency, loader, baseName);
        }
        finally {
            if (!this.keepGeneratedScript) {
                this.delete(scriptDir);
            }
        }
    }

    private void runScript(boolean mavenProjectDependency, URLClassLoader loader, String baseName) throws Exception {
        Class<?> compiledScript = loader.loadClass(baseName);
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            try {
                Object instance;
                if (mavenProjectDependency) {
                    Constructor<?> constructor = compiledScript.getConstructor(MavenProject.class, MavenSession.class, Log.class);
                    instance = constructor.newInstance(this.project, this.session, this.getLog());
                } else {
                    instance = compiledScript.newInstance();
                }
                try {
                    compiledScript.getMethod("run", new Class[0]).invoke(instance, new Object[0]);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            catch (ExceptionInInitializerError e) {
                if (e.getException() != null) {
                    throw e.getException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception("A " + e.getClass().getSimpleName() + " exception was thrown", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }

    private URLClassLoader createScriptClassloader(File scriptDir, Set<String> classpath) throws Exception {
        ClassWorld w = new ClassWorld("zero", null);
        w.newRealm("mojo", ((Object)((Object)this)).getClass().getClassLoader());
        SelfFirstStrategy s = new SelfFirstStrategy(w.newRealm("scalaScript", null));
        ClassRealm rScript = s.getRealm();
        rScript.setParentClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        rScript.importFrom("mojo", "org.apache.maven");
        rScript.addURL(scriptDir.toURI().toURL());
        for (String string : classpath) {
            rScript.addURL(new File(string).toURI().toURL());
        }
        return rScript;
    }

    private void compileScript(File scriptDir, File destFile, URLClassLoader loader) throws Exception {
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", MainHelper.toClasspathString(loader));
        jcmd.addArgs("-d", scriptDir.getAbsolutePath());
        jcmd.addArgs("-sourcepath", scriptDir.getAbsolutePath());
        jcmd.addArgs(destFile.getAbsolutePath());
        jcmd.run(this.displayCmd);
    }

    private void configureClasspath(Set<String> classpath) throws Exception, DependencyResolutionRequiredException {
        TreeSet<String> includes = new TreeSet<String>(Arrays.asList(this.includeScopes.toLowerCase().split(",")));
        TreeSet<String> excludes = new TreeSet<String>(Arrays.asList(this.excludeScopes.toLowerCase().split(",")));
        for (Artifact a : this.project.getArtifacts()) {
            if (!includes.contains(a.getScope().toLowerCase()) || excludes.contains(a.getScope())) continue;
            this.addToClasspath(a, classpath, true);
        }
        if (includes.contains("plugin") && !excludes.contains("plugin")) {
            for (Artifact a : this.project.getPluginArtifacts()) {
                if (!"scala-maven-plugin".equals(a.getArtifactId())) continue;
                this.addToClasspath(a, classpath, true);
            }
        }
        if (this.addToClasspath != null) {
            classpath.addAll(Arrays.asList(this.addToClasspath.split(",")));
        }
        if (this.removeFromClasspath != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            String[] jars = this.removeFromClasspath.trim().split(",");
            for (String string : classpath) {
                for (String jar : jars) {
                    if (!string.contains(jar.trim())) continue;
                    toRemove.add(string);
                }
            }
            classpath.removeAll(toRemove);
        }
        this.addCompilerToClasspath(classpath);
        this.addLibraryToClasspath(classpath);
        boolean ok = true;
        for (String s : classpath) {
            File f = new File(s);
            this.getLog().debug((CharSequence)("classpath entry for running and compiling scripts: " + f));
            if (f.exists()) continue;
            this.getLog().error((CharSequence)("classpath entry for script not found : " + f));
            ok = false;
        }
        if (!ok) {
            throw new MojoFailureException("some script dependencies not found (see log)");
        }
        this.getLog().debug((CharSequence)("Using the following classpath for running and compiling scripts: " + classpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapScript(File destFile, boolean mavenProjectDependency) throws IOException {
        destFile.delete();
        FileOutputStream fileOutputStream = new FileOutputStream(destFile);
        PrintStream out = new PrintStream(fileOutputStream);
        try {
            BufferedReader reader = this.scriptFile != null ? new BufferedReader(new FileReader(this.scriptFile)) : new BufferedReader(new StringReader(this.script));
            String baseName = FileUtils.basename((String)destFile.getName(), (String)".scala");
            if (mavenProjectDependency) {
                out.println("class " + baseName + "(project :" + MavenProject.class.getCanonicalName() + ",session :" + MavenSession.class.getCanonicalName() + ",log :" + Log.class.getCanonicalName() + ") {");
            } else {
                out.println("class " + baseName + " {");
            }
            String line = reader.readLine();
            while (line != null) {
                out.print("  ");
                out.println(line);
                line = reader.readLine();
            }
            out.println("}");
        }
        finally {
            out.close();
            fileOutputStream.close();
        }
    }

    private void delete(File scriptDir) {
        if (scriptDir.isDirectory()) {
            for (File file : scriptDir.listFiles()) {
                this.delete(file);
            }
        }
        scriptDir.deleteOnExit();
        scriptDir.delete();
    }
}

