/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.ExtractedFileSets;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.File;
import java.io.IOException;

public class ExtractedArtifactStore
implements IArtifactStore {
    private final IDownloadConfig downloadConfig;
    private final IDownloader downloader;
    private final DirectoryAndExecutableNaming extraction;
    private final DirectoryAndExecutableNaming temp;

    public ExtractedArtifactStore(IDownloadConfig downloadConfig, IDownloader downloader, DirectoryAndExecutableNaming extraction, DirectoryAndExecutableNaming temp) {
        this.downloadConfig = downloadConfig;
        this.downloader = downloader;
        this.extraction = extraction;
        this.temp = temp;
    }

    @Override
    public boolean checkDistribution(Distribution distribution) throws IOException {
        return this.store().checkDistribution(distribution);
    }

    private ArtifactStore store() {
        return new ArtifactStore(this.downloadConfig, this.extraction.getDirectory(), this.extraction.getExecutableNaming(), this.downloader);
    }

    private ArtifactStore store(IDirectory withDistribution, ITempNaming naming) {
        return new ArtifactStore(this.downloadConfig, withDistribution, naming, this.downloader);
    }

    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IDirectory withDistribution = ExtractedArtifactStore.withDistribution(this.extraction.getDirectory(), distribution);
        ArtifactStore baseStore = this.store(withDistribution, this.extraction.getExecutableNaming());
        boolean foundExecutable = false;
        File destinationDir = withDistribution.asFile();
        ImmutableExtractedFileSet.Builder fileSetBuilder = ImmutableExtractedFileSet.builder(destinationDir).baseDirIsGenerated(withDistribution.isGenerated());
        FilesToExtract filesToExtract = baseStore.filesToExtract(distribution);
        for (FileSet.Entry file : filesToExtract.files()) {
            if (file.type() == FileType.Executable) {
                String executableName = FilesToExtract.executableName(this.extraction.getExecutableNaming(), file);
                File executableFile = new File(executableName);
                File resolvedExecutableFile = new File(destinationDir, executableName);
                if (resolvedExecutableFile.isFile()) {
                    foundExecutable = true;
                }
                fileSetBuilder.file(file.type(), executableFile);
                continue;
            }
            fileSetBuilder.file(file.type(), new File(FilesToExtract.fileName(file)));
        }
        if (!foundExecutable) {
            try {
                baseStore.extractFileSet(distribution);
            }
            catch (FileAlreadyExistsException fx) {
                throw new RuntimeException("extraction to " + destinationDir + " has failed", fx);
            }
        }
        IExtractedFileSet extractedFileSet = fileSetBuilder.build();
        return ExtractedFileSets.copy(extractedFileSet, this.temp.getDirectory(), this.temp.getExecutableNaming());
    }

    private static IDirectory withDistribution(final IDirectory dir, final Distribution distribution) {
        return new IDirectory(){

            @Override
            public boolean isGenerated() {
                return dir.isGenerated();
            }

            @Override
            public File asFile() {
                File file = new File(dir.asFile(), ExtractedArtifactStore.asPath(distribution));
                if (!file.exists() && !file.mkdirs()) {
                    throw new RuntimeException("could not create dir " + file);
                }
                return file;
            }
        };
    }

    static String asPath(Distribution distribution) {
        return distribution.getPlatform().name() + "-" + distribution.getBitsize().name() + "--" + distribution.getVersion().asInDownloadPath();
    }

    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet files) {
        ExtractedFileSets.delete(files);
    }
}

