/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container;

import com.sun.jersey.api.InBoundHeaders;
import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.impl.MultivaluedMapImpl;
import com.sun.jersey.impl.VariantSelector;
import com.sun.jersey.impl.http.header.AcceptableLanguageTag;
import com.sun.jersey.impl.http.header.AcceptableMediaType;
import com.sun.jersey.impl.http.header.HttpHeaderFactory;
import com.sun.jersey.impl.http.header.reader.HttpHeaderReader;
import com.sun.jersey.impl.model.HttpHelper;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerRequest
implements HttpRequestContext {
    private static final Logger LOGGER = Logger.getLogger(ContainerRequest.class.getName());
    private static final Annotation[] EMTPTY_ANNOTATIONS = new Annotation[0];
    private final MessageBodyWorkers bodyContext;
    private String method;
    private InputStream entity;
    private URI baseUri;
    private URI requestUri;
    private URI absolutePathUri;
    private String encodedPath;
    private String decodedPath;
    private List<PathSegment> decodedPathSegments;
    private List<PathSegment> encodedPathSegments;
    private MultivaluedMap<String, String> decodedQueryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private InBoundHeaders headers;
    private int headersModCount;
    private MediaType contentType;
    private List<MediaType> accept;
    private List<Locale> acceptLanguages;
    private Map<String, Cookie> cookies;
    private MultivaluedMap<String, String> cookieNames;

    public ContainerRequest(WebApplication wa, String method, URI baseUri, URI requestUri, InBoundHeaders headers, InputStream entity) {
        this.bodyContext = wa.getMessageBodyWorkers();
        this.method = method;
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        this.headers = headers;
        this.headersModCount = headers.getModCount();
        this.entity = entity;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setUris(URI baseUri, URI requestUri) {
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        this.absolutePathUri = null;
        this.decodedPath = null;
        this.encodedPath = null;
        this.encodedPathSegments = null;
        this.decodedPathSegments = null;
        this.encodedQueryParameters = null;
        this.decodedQueryParameters = null;
    }

    public InputStream getEntityInputStream() {
        return this.entity;
    }

    public void setEntityInputStream(InputStream entity) {
        this.entity = entity;
    }

    public void setHeaders(InBoundHeaders headers) {
        this.headers = headers;
        this.headersModCount = headers.getModCount();
        this.contentType = null;
        this.accept = null;
        this.cookies = null;
        this.cookieNames = null;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public URI getAbsolutePath() {
        if (this.absolutePathUri != null) {
            return this.absolutePathUri;
        }
        this.absolutePathUri = UriBuilder.fromUri((URI)this.requestUri).replaceQuery("").fragment("").build(new Object[0]);
        return this.absolutePathUri;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (decode) {
            if (this.decodedPath != null) {
                return this.decodedPath;
            }
            this.decodedPath = UriComponent.decode((String)this.getEncodedPath(), (UriComponent.Type)UriComponent.Type.PATH);
            return this.decodedPath;
        }
        return this.getEncodedPath();
    }

    private String getEncodedPath() {
        if (this.encodedPath != null) {
            return this.encodedPath;
        }
        this.encodedPath = this.getRequestUri().getRawPath().substring(this.getBaseUri().getRawPath().length());
        return this.encodedPath;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            if (this.decodedPathSegments != null) {
                return this.decodedPathSegments;
            }
            this.decodedPathSegments = UriComponent.decodePath((String)this.getPath(false), (boolean)true);
            return this.decodedPathSegments;
        }
        if (this.encodedPathSegments != null) {
            return this.encodedPathSegments;
        }
        this.encodedPathSegments = UriComponent.decodePath((String)this.getPath(false), (boolean)false);
        return this.encodedPathSegments;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            if (this.decodedQueryParameters != null) {
                return this.decodedQueryParameters;
            }
            this.decodedQueryParameters = UriComponent.decodeQuery((URI)this.getRequestUri(), (boolean)true);
            return this.decodedQueryParameters;
        }
        if (this.encodedQueryParameters != null) {
            return this.encodedQueryParameters;
        }
        this.encodedQueryParameters = UriComponent.decodeQuery((URI)this.getRequestUri(), (boolean)false);
        return this.encodedQueryParameters;
    }

    public String getHeaderValue(String name) {
        List v = (List)this.getRequestHeaders().get((Object)name);
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return "";
        }
        if (v.size() == 1) {
            return (String)v.get(0);
        }
        StringBuilder sb = new StringBuilder((String)v.get(0));
        for (int i = 1; i < v.size(); ++i) {
            String s = (String)v.get(i);
            if (s.length() <= 0) continue;
            sb.append(',').append(s);
        }
        return sb.toString();
    }

    public <T> T getEntity(Class<T> type, Type genericType, Annotation[] as) {
        try {
            MediaType mediaType = this.getMediaType();
            MessageBodyReader bw = this.bodyContext.getMessageBodyReader(type, genericType, as, mediaType);
            if (bw == null) {
                LOGGER.severe("A message body reader for Java type, " + type + ", and MIME media type, " + mediaType + ", was not found");
                throw new WebApplicationException(Responses.unsupportedMediaType().build());
            }
            return (T)bw.readFrom(type, genericType, as, mediaType, (MultivaluedMap)this.headers, this.entity);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T getEntity(Class<T> type) {
        return this.getEntity(type, type, EMTPTY_ANNOTATIONS);
    }

    public MediaType getAcceptableMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return this.getAcceptableMediaTypes().get(0);
        }
        for (MediaType a : this.getAcceptableMediaTypes()) {
            if (a.getType().equals("*")) {
                return mediaTypes.get(0);
            }
            for (MediaType m : mediaTypes) {
                if (!m.isCompatible(a) || m.isWildcardType() || m.isWildcardSubtype()) continue;
                return m;
            }
        }
        return null;
    }

    public MultivaluedMap<String, String> getCookieNameValueMap() {
        if (this.cookieNames == null || this.headersModCount != this.headers.getModCount()) {
            this.cookieNames = new MultivaluedMapImpl();
            for (Map.Entry<String, Cookie> e : this.getCookies().entrySet()) {
                this.cookieNames.putSingle((Object)e.getKey(), (Object)e.getValue().getValue());
            }
        }
        return this.cookieNames;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.headers;
    }

    public List<String> getRequestHeader(String name) {
        return (List)this.headers.get((Object)name);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        if (this.accept == null || this.headersModCount != this.headers.getModCount()) {
            this.accept = new ArrayList<AcceptableMediaType>(HttpHelper.getAccept(this));
        }
        return this.accept;
    }

    public List<Locale> getAcceptableLanguages() {
        if (this.acceptLanguages == null || this.headersModCount != this.headers.getModCount()) {
            List<AcceptableLanguageTag> alts = HttpHelper.getAcceptLangauge(this);
            this.acceptLanguages = new ArrayList<Locale>(alts.size());
            for (AcceptableLanguageTag alt : alts) {
                this.acceptLanguages.add(alt.getAsLocale());
            }
        }
        return this.acceptLanguages;
    }

    public MediaType getMediaType() {
        if (this.contentType == null || this.headersModCount != this.headers.getModCount()) {
            this.contentType = HttpHelper.getContentType(this);
        }
        return this.contentType;
    }

    public Locale getLanguage() {
        String localeString = (String)this.getRequestHeaders().getFirst((Object)"Content-Language");
        if (localeString == null) {
            return null;
        }
        return new Locale(localeString);
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null || this.headersModCount != this.headers.getModCount()) {
            this.cookies = new HashMap<String, Cookie>();
            List cl = (List)this.getRequestHeaders().get((Object)"Cookie");
            if (cl != null) {
                for (String cookie : cl) {
                    if (cookie == null) continue;
                    this.cookies.putAll(HttpHeaderFactory.createCookies((String)cookie));
                }
            }
        }
        return this.cookies;
    }

    public String getMethod() {
        return this.method;
    }

    public Variant selectVariant(List<Variant> variants) {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("The list of variants is null or empty");
        }
        return VariantSelector.selectVariant(this, variants);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            r = this.evaluateIfNoneMatch(eTag);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r == null) {
            r = this.evaluateIfModifiedSince(lastModifiedTime);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            long lastModifiedTime = lastModified.getTime();
            r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
            if (r == null) {
                r = this.evaluateIfNoneMatch(eTag);
            }
            if (r == null) {
                return null;
            }
            r = this.evaluateIfModifiedSince(lastModifiedTime);
            if (r != null) {
                r.tag(eTag);
            }
        }
        return r;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        String ifMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Match");
        if (ifMatchHeader != null && !ifMatchHeader.trim().equals("*") && !ifMatchHeader.contains(eTag.getValue())) {
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        String ifNoneMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-None-Match");
        if (ifNoneMatchHeader != null && (ifNoneMatchHeader.trim().equals("*") || ifNoneMatchHeader.contains(eTag.getValue()))) {
            String httpMethod = this.getMethod();
            if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
                return Response.notModified((EntityTag)eTag);
            }
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(long lastModified) {
        String ifUnmodifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Unmodified-Since");
        if (ifUnmodifiedSinceHeader != null) {
            try {
                long ifUnmodifiedSince = HttpHeaderReader.readDate((String)ifUnmodifiedSinceHeader).getTime() + 1000L;
                if (lastModified > ifUnmodifiedSince) {
                    return Responses.preconditionFailed();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified) {
        String ifModifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Modified-Since");
        if (ifModifiedSinceHeader != null) {
            try {
                long ifModifiedSince = HttpHeaderReader.readDate((String)ifModifiedSinceHeader).getTime() + 1000L;
                if (ifModifiedSince > lastModified) {
                    return Responses.notModified();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationScheme() {
        throw new UnsupportedOperationException();
    }
}

