/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.InfoProvider;
import com.rodiontsev.maven.plugins.buildinfo.utils.InfoWriter;
import com.rodiontsev.maven.plugins.buildinfo.utils.PropertyMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ProjectPropertiesProvider
implements InfoProvider {
    @Override
    public Map<String, String> getInfo(MavenProject project, BuildInfoMojo mojo) {
        final LinkedHashMap<String, String> projectProperties = new LinkedHashMap<String, String>(65);
        projectProperties.put("project.id", project.getId());
        projectProperties.put("project.groupId", project.getGroupId());
        projectProperties.put("project.artifactId", project.getArtifactId());
        projectProperties.put("project.version", project.getVersion());
        projectProperties.put("project.name", project.getName());
        projectProperties.put("project.description", project.getDescription());
        projectProperties.put("project.modelVersion", project.getModelVersion());
        projectProperties.put("project.inceptionYear", project.getInceptionYear());
        projectProperties.put("project.packaging", project.getPackaging());
        projectProperties.put("project.url", project.getUrl());
        MavenProject parent = project.getParent();
        if (parent != null) {
            projectProperties.put("project.parent.id", parent.getId());
            projectProperties.put("project.parent.groupId", parent.getGroupId());
            projectProperties.put("project.parent.artifactId", parent.getArtifactId());
            projectProperties.put("project.parent.version", parent.getVersion());
            projectProperties.put("project.parent.name", parent.getName());
            projectProperties.put("project.parent.description", parent.getDescription());
            projectProperties.put("project.parent.modelVersion", parent.getModelVersion());
            projectProperties.put("project.parent.inceptionYear", parent.getInceptionYear());
            projectProperties.put("project.parent.packaging", parent.getPackaging());
            projectProperties.put("project.parent.url", parent.getUrl());
        }
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        new InfoWriter().write(info, mojo.getProjectProperties(), new PropertyMapper(){

            @Override
            public String mapProperty(String propertyName) {
                return (String)projectProperties.get(propertyName);
            }
        });
        return info;
    }
}

