/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.providers.AbstractVcsInfoProvider;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class MercurialInfoProvider
extends AbstractVcsInfoProvider {
    private static final String DOT_HG = ".hg";
    private static final Pattern HG_OUTPUT_PATTERN = Pattern.compile("^(\\S+)\\s(\\S+)\\s(.+)$");

    @Override
    protected boolean isActive(MavenProject project, BuildInfoMojo mojo) {
        return this.isDirectoryExists(project, DOT_HG);
    }

    @Override
    protected Map<String, String> getScmInfo(MavenProject project, BuildInfoMojo mojo) {
        ScmResult result;
        block8: {
            DefaultLog logger = new DefaultLog();
            HgLogConsumer consumer = new HgLogConsumer((ScmLogger)logger);
            result = null;
            try {
                result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)logger, (File)project.getBasedir(), (String[])new String[]{"id", "-n", "-i", "-b"});
            }
            catch (ScmException e) {
                if (!logger.isErrorEnabled()) break block8;
                logger.error(e.getMessage());
            }
        }
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        if (result != null) {
            if (result.isSuccess()) {
                String output = result.getCommandOutput();
                if (output != null) {
                    Matcher matcher = HG_OUTPUT_PATTERN.matcher(output);
                    if (matcher.find() && matcher.groupCount() == 3) {
                        StringBuilder changeset = new StringBuilder();
                        changeset.append("r").append(matcher.group(2)).append(":").append(matcher.group(1));
                        info.put("hg.changeset", changeset.toString());
                        info.put("hg.branch", matcher.group(3));
                    } else {
                        info.put("hg.error", "The command returned incorrect number of arguments");
                    }
                }
            } else {
                info.put("hg.error", result.getProviderMessage());
            }
        }
        return info;
    }

    private class HgLogConsumer
    extends HgConsumer {
        private final StringBuilder out;

        public HgLogConsumer(ScmLogger logger) {
            super(logger);
            this.out = new StringBuilder();
        }

        public void consumeLine(String line) {
            this.out.append(line).append("\n");
        }

        public String getStdErr() {
            return this.out.toString();
        }
    }
}

