/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.providers.AbstractVcsInfoProvider;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.GitExeScmProvider;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;

public class GitInfoProvider
extends AbstractVcsInfoProvider {
    private static final String DOT_GIT = ".git";

    @Override
    protected boolean isActive(MavenProject project, BuildInfoMojo mojo) {
        return this.isDirectoryExists(project, DOT_GIT);
    }

    @Override
    protected Map<String, String> getScmInfo(MavenProject project, BuildInfoMojo mojo) {
        InfoScmResult infoResult;
        block7: {
            File basedir = project.getBasedir();
            DefaultLog logger = new DefaultLog();
            ScmFileSet fileSet = new ScmFileSet(basedir);
            GitCommand infoCommand = new GitExeScmProvider().getInfoCommand();
            infoCommand.setLogger((ScmLogger)logger);
            infoResult = null;
            try {
                GitScmProviderRepository repository = new GitScmProviderRepository(basedir.getAbsolutePath());
                CommandParameters parameters = new CommandParameters();
                infoResult = (InfoScmResult)infoCommand.execute((ScmProviderRepository)repository, fileSet, parameters);
            }
            catch (ScmException e) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error(e.getMessage());
            }
        }
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        if (infoResult != null) {
            if (infoResult.isSuccess()) {
                List items = infoResult.getInfoItems();
                if (items != null && items.size() == 1) {
                    info.put("git.revision", ((InfoItem)items.get(0)).getRevision());
                } else {
                    info.put("git.error", "The command returned incorrect number of arguments");
                }
            } else {
                info.put("git.error", infoResult.getProviderMessage());
            }
        }
        return info;
    }
}

