/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.InfoProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public abstract class AbstractVcsInfoProvider
implements InfoProvider {
    private File lookup(File parent, String child) throws FileNotFoundException {
        if (parent == null) {
            throw new FileNotFoundException("Could not find " + child + " directory");
        }
        File dir = new File(parent, child);
        return dir.exists() && dir.isDirectory() ? dir : this.lookup(parent.getParentFile(), child);
    }

    protected boolean isDirectoryExists(MavenProject project, String child) {
        boolean result = false;
        try {
            File dir = this.lookup(project.getBasedir(), child);
            result = dir.exists() && dir.isDirectory();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    protected abstract boolean isActive(MavenProject var1, BuildInfoMojo var2);

    protected abstract Map<String, String> getScmInfo(MavenProject var1, BuildInfoMojo var2);

    @Override
    public Map<String, String> getInfo(MavenProject project, BuildInfoMojo mojo) {
        return mojo.isIncludeVcsInfo() && this.isActive(project, mojo) ? this.getScmInfo(project, mojo) : Collections.emptyMap();
    }
}

