/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubException;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSender {
    private static final Logger logger = LoggerFactory.getLogger(EventHubSender.class);
    private final Session session;
    private final String entityPath;
    private final String partitionId;
    private final String destinationAddress;
    private Sender sender;

    public EventHubSender(Session session, String entityPath, String partitionId) {
        this.session = session;
        this.entityPath = entityPath;
        this.partitionId = partitionId;
        this.destinationAddress = this.getDestinationAddress();
    }

    public void send(byte[] data) throws EventHubException {
        try {
            if (this.sender == null) {
                this.ensureSenderCreated();
            }
            Binary bin = new Binary(data);
            Message message = new Message((Section)new Data(bin));
            this.sender.send(message);
        }
        catch (LinkDetachedException e) {
            logger.error(e.getMessage());
            EventHubException eventHubException = new EventHubException("Sender has been closed");
            throw eventHubException;
        }
        catch (TimeoutException e) {
            logger.error(e.getMessage());
            EventHubException eventHubException = new EventHubException("Timed out while waiting to get credit to send");
            throw eventHubException;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void send(String data) throws EventHubException {
        this.send(data.getBytes());
    }

    public void close() {
        try {
            this.sender.close();
        }
        catch (Sender.SenderClosingException e) {
            logger.error("Closing a sender encountered error: " + e.getMessage());
        }
    }

    private String getDestinationAddress() {
        if (this.partitionId == null || this.partitionId.equals("")) {
            return this.entityPath;
        }
        return String.format("%s/Partitions/%s", this.entityPath, this.partitionId);
    }

    private synchronized void ensureSenderCreated() throws Exception {
        if (this.sender == null) {
            this.sender = this.session.createSender(this.destinationAddress);
        }
    }
}

