/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.FileRequest;
import com.microsoft.azure.storage.file.FileRequestOptions;
import com.microsoft.azure.storage.file.FileResponse;
import com.microsoft.azure.storage.file.FileShareAttributes;
import com.microsoft.azure.storage.file.FileShareProperties;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public final class CloudFileShare {
    protected HashMap<String, String> metadata = new HashMap();
    FileShareProperties properties = new FileShareProperties();
    String name;
    private StorageUri storageUri;
    private CloudFileClient fileServiceClient;

    private CloudFileShare(CloudFileClient client) {
        this.fileServiceClient = client;
    }

    public CloudFileShare(String shareName, CloudFileClient client) throws URISyntaxException, StorageException {
        this(client);
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("shareName", shareName);
        this.storageUri = PathUtility.appendPathToUri(client.getStorageUri(), shareName);
        this.name = shareName;
        this.parseQueryAndVerify(this.storageUri, client, client.isUsePathStyleUris());
    }

    public CloudFileShare(URI uri, CloudFileClient client) throws StorageException, URISyntaxException {
        this(new StorageUri(uri), client);
    }

    public CloudFileShare(StorageUri storageUri, CloudFileClient client) throws StorageException, URISyntaxException {
        this(client);
        Utility.assertNotNull("storageUri", storageUri);
        this.storageUri = storageUri;
        this.parseQueryAndVerify(this.storageUri, client, client == null ? Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri()) : client.isUsePathStyleUris());
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.createImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> createImpl(final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                HttpURLConnection request = FileRequest.createShare(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context);
                return request;
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileShare share, OperationContext context) {
                FileRequest.addMetadata(connection, share.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileShareAttributes attributes = FileResponse.getFileShareAttributes(this.getConnection(), client.isUsePathStyleUris());
                share.properties = attributes.getProperties();
                share.name = attributes.getName();
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, null, options = FileRequestOptions.applyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "ShareAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null, null);
    }

    @DoesServiceRequest
    public void delete(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.deleteImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> deleteImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.deleteShare(share.getStorageUri().getPrimaryUri(), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, accessCondition, options = FileRequestOptions.applyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            try {
                this.delete(accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "ShareNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> downloadAttributesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getShareProperties(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileShareAttributes attributes = FileResponse.getFileShareAttributes(this.getConnection(), client.isUsePathStyleUris());
                share.metadata = attributes.getMetadata();
                share.properties = attributes.getProperties();
                share.name = attributes.getName();
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public boolean exists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Boolean> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getShareProperties(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Boolean preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    share.updatePropertiesFromResponse(this.getConnection());
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    private void updatePropertiesFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    private StorageRequest<CloudFileClient, CloudFileShare, Void> uploadMetadataImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.setShareMetadata(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileShare share, OperationContext context) {
                FileRequest.addMetadata(connection, share.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                share.updatePropertiesFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    public CloudFileDirectory getRootDirectoryReference() throws StorageException, URISyntaxException {
        return new CloudFileDirectory(this.storageUri, this.fileServiceClient);
    }

    private void parseQueryAndVerify(StorageUri completeUri, CloudFileClient existingClient, boolean usePathStyleUri) throws StorageException, URISyntaxException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        this.fileServiceClient = existingClient == null ? new CloudFileClient(PathUtility.getServiceClientBaseAddress(this.storageUri, usePathStyleUri), null) : existingClient;
        this.name = PathUtility.getShareNameFromUri(completeUri.getPrimaryUri(), usePathStyleUri);
    }

    public CloudFileClient getServiceClient() {
        return this.fileServiceClient;
    }

    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public StorageUri getStorageUri() {
        return this.storageUri;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public FileShareProperties getProperties() {
        return this.properties;
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected void setProperties(FileShareProperties properties) {
        this.properties = properties;
    }

    private StorageUri getTransformedAddress() throws URISyntaxException, StorageException {
        return this.fileServiceClient.getCredentials().transformUri(this.storageUri);
    }
}

