/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;

public class MailCommand
extends SmtpCommand {
    static final Pattern param = Pattern.compile("MAIL FROM:\\s?<(.*)>", 2);

    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) {
        Matcher m = param.matcher(commandLine);
        try {
            if (m.matches()) {
                String from = m.group(1);
                MailAddress fromAddr = new MailAddress(from);
                String err = manager.checkSender(state, fromAddr);
                if (err != null) {
                    conn.println(err);
                    return;
                }
                state.clearMessage();
                state.getMessage().setReturnPath(fromAddr);
                conn.println("250 OK");
            } else {
                conn.println("501 Required syntax: 'MAIL FROM:<email@host>'");
            }
        }
        catch (AddressException e) {
            conn.println("501 Malformed email address. Use form email@host");
        }
    }
}

