/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifact
extends AbstractMojo {
    private String artifactId;
    private String groupId;
    private String version;
    private String type;
    private String classifier;
    private File outputDirectory;
    private String outputFileName;
    private boolean unpack;
    private long dependencyDepth;
    private List remoteRepositories;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadatSource;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArchiverManager archiverManager;
    private ArtifactRepository localRepository;
    private final Set<org.apache.maven.artifact.Artifact> artifactToCopy = new HashSet<org.apache.maven.artifact.Artifact>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dependencyDepth > 0L && this.outputFileName != null) {
            throw new MojoFailureException("Cannot have a dependency depth higher than 0 and an outputFileName");
        }
        org.apache.maven.artifact.Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
        this.downloadAndAddArtifact(artifact, this.dependencyDepth);
        for (org.apache.maven.artifact.Artifact copy : this.artifactToCopy) {
            if (this.unpack) {
                this.unpackFileToDirectory(copy);
                continue;
            }
            this.copyFileToDirectory(copy);
        }
    }

    private void downloadAndAddArtifact(org.apache.maven.artifact.Artifact artifact, long dependencyDepth2) throws MojoFailureException {
        this.downloadArtifact(artifact);
        this.artifactToCopy.add(artifact);
        if (this.dependencyDepth > 0L) {
            Set<org.apache.maven.artifact.Artifact> dependencies = this.getTransitiveDependency(artifact);
            this.getLog().debug((CharSequence)("Nummber dependencies : " + dependencies.size()));
            for (org.apache.maven.artifact.Artifact dependency : dependencies) {
                this.downloadAndAddArtifact(dependency, dependencyDepth2 - 1L);
            }
        }
    }

    private void downloadArtifact(org.apache.maven.artifact.Artifact artifact) throws MojoFailureException {
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().debug((CharSequence)"Artifact could not be resolved.", (Throwable)e);
            throw new MojoFailureException("Artifact could not be resolved.");
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)"Artifact could not be found.", (Throwable)e);
            throw new MojoFailureException("Artifact could not be found.");
        }
    }

    private void copyFileToDirectory(org.apache.maven.artifact.Artifact artifact) throws MojoFailureException {
        File toCopy = artifact.getFile();
        if (toCopy != null && toCopy.exists() && toCopy.isFile()) {
            try {
                this.getLog().info((CharSequence)("Copying file " + toCopy.getName() + " to directory " + this.outputDirectory));
                File outputFile = null;
                outputFile = this.outputFileName == null ? new File(this.outputDirectory, toCopy.getName()) : new File(this.outputDirectory, this.outputFileName);
                FileUtils.copyFile((File)toCopy, (File)outputFile);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"Error while copying file", (Throwable)e);
                throw new MojoFailureException("Error copying the file : " + e.getMessage());
            }
        } else {
            throw new MojoFailureException("Artifact file not present : " + toCopy);
        }
    }

    private void unpackFileToDirectory(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        File toUnpack = artifact.getFile();
        if (toUnpack != null && toUnpack.exists() && toUnpack.isFile()) {
            try {
                UnArchiver unarchiver = this.archiverManager.getUnArchiver(toUnpack);
                unarchiver.setSourceFile(toUnpack);
                unarchiver.setDestDirectory(this.outputDirectory);
                unarchiver.extract();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Issue while unarchiving", ex);
            }
        }
    }

    private Set<org.apache.maven.artifact.Artifact> getTransitiveDependency(org.apache.maven.artifact.Artifact artifact) throws MojoFailureException {
        try {
            org.apache.maven.artifact.Artifact pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), "pom");
            MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
            Set dependents = pomProject.createArtifacts(this.artifactFactory, null, null);
            ArtifactResolutionResult result = this.resolver.resolveTransitively(dependents, pomArtifact, this.localRepository, this.remoteRepositories, this.metadatSource, null);
            if (result != null) {
                this.getLog().debug((CharSequence)("Found transitive dependency : " + result));
                return result.getArtifacts();
            }
        }
        catch (ArtifactResolutionException e) {
            this.getLog().debug((CharSequence)"Could not resolved the dependency", (Throwable)e);
            throw new MojoFailureException("Could not resolved the dependency : " + e.getMessage());
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)"Could not find the dependency", (Throwable)e);
            throw new MojoFailureException("Could not find the dependency : " + e.getMessage());
        }
        catch (ProjectBuildingException e) {
            this.getLog().debug((CharSequence)("Error Creating the pom project for artifact : " + artifact), (Throwable)e);
            throw new MojoFailureException("Error getting transitive dependencies : " + e.getMessage());
        }
        catch (InvalidDependencyVersionException e) {
            this.getLog().debug((CharSequence)("Error Creating the pom project for artifact : " + artifact), (Throwable)e);
            throw new MojoFailureException("Error getting transitive dependencies : " + e.getMessage());
        }
        return null;
    }
}

