/*
 * Decompiled with CFR 0.152.
 */
package rat.report.claim.impl.xml;

import java.io.IOException;
import rat.report.RatReportFailedException;
import rat.report.claim.IClaimReporter;
import rat.report.xml.writer.IXmlWriter;

public class SimpleXmlClaimReporter
implements IClaimReporter {
    private static final String NAME = "name";
    private final IXmlWriter writer;
    private CharSequence lastSubject;

    public SimpleXmlClaimReporter(IXmlWriter writer) {
        this.writer = writer;
    }

    public void claim(CharSequence subject, CharSequence predicate, CharSequence object, boolean isLiteral) throws RatReportFailedException {
        try {
            if (!subject.equals(this.lastSubject)) {
                if (this.lastSubject != null) {
                    this.writer.closeElement();
                }
                this.writer.openElement("resource").attribute(NAME, subject);
            }
            if (isLiteral) {
                this.writer.openElement(predicate).content(object).closeElement();
            } else {
                this.writer.openElement(predicate).attribute(NAME, object).closeElement();
            }
            this.lastSubject = subject;
        }
        catch (IOException e) {
            throw new RatReportFailedException("XML writing failure: " + e.getMessage() + " subject: " + subject + " predicate: " + predicate, e);
        }
    }
}

