/*
 * Copyright 2006 Robert Burrell Donkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package rat.report.analyser;

import java.io.IOException;
import java.io.Reader;

import rat.analysis.IHeaderMatcher;
import rat.analysis.RatHeaderAnalysisException;
import rat.document.IDocument;
import rat.document.IDocumentAnalyser;
import rat.document.RatDocumentAnalysisException;
import rat.report.claim.IClaimReporter;

public class DocumentHeaderAnalyser implements IDocumentAnalyser {

    private final IHeaderMatcher matcher;
    // TODO: coupling to unknown license should be replaced
    private final IClaimReporter reporter;
    
    public DocumentHeaderAnalyser(final IHeaderMatcher matcher, final IClaimReporter reporter) {
        super();
        this.matcher = matcher;
        this.reporter = reporter;
    }

    public void analyse(IDocument document) throws RatDocumentAnalysisException {
        Reader reader = null;
        try {
            reader = document.reader();
            final String name = document.getName();
            // TODO: worker function should be moved into this class
            HeaderCheckWorker worker = new HeaderCheckWorker(reader, matcher, reporter, name);
            worker.read();
        } catch (IOException e) {
            throw new RatDocumentAnalysisException("Cannot read header", e);
        } catch (RatHeaderAnalysisException e) {
            throw new RatDocumentAnalysisException("Cannot analyse header", e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    // SWALLOW
                }
            }
        }
     }

}
