/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.JsonInputException;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.UninitializedMessageException;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonInput
implements Input {
    public final JsonParser parser;
    public final boolean numeric;
    private boolean lastRepeated;
    private String lastName;
    private int lastNumber;

    public JsonInput(JsonParser parser) {
        this(parser, false);
    }

    public JsonInput(JsonParser parser, boolean numeric) {
        this.parser = parser;
        this.numeric = numeric;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public JsonInput reset() {
        this.lastRepeated = false;
        this.lastName = null;
        this.lastNumber = 0;
        return this;
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        if (this.parser.getCurrentToken().isScalarValue()) {
            if (this.lastRepeated) {
                this.lastRepeated = false;
                while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                }
            }
            return;
        }
        throw new JsonInputException("Unknown field: " + (this.numeric ? Integer.valueOf(fieldNumber) : this.lastName) + " on message " + schema.messageFullName());
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (this.lastRepeated) {
            if (this.parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                JsonToken jt;
                while (JsonToken.VALUE_NULL == (jt = this.parser.nextToken())) {
                }
                if (jt == JsonToken.END_ARRAY) {
                    this.lastRepeated = false;
                    return this.readFieldNumber(schema, this.parser);
                }
            }
            return this.lastNumber;
        }
        return this.readFieldNumber(schema, this.parser);
    }

    private <T> int readFieldNumber(Schema<T> schema, JsonParser parser) throws IOException {
        int number;
        String name;
        block9: {
            block0: while (true) {
                if (parser.nextToken() == JsonToken.END_OBJECT) {
                    return 0;
                }
                if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
                    throw new JsonInputException("Expected token: $field: but was " + parser.getCurrentToken() + " on message " + schema.messageFullName());
                }
                name = parser.getCurrentName();
                if (parser.nextToken() == JsonToken.START_ARRAY) {
                    int number2;
                    JsonToken jt = parser.nextToken();
                    if (jt == JsonToken.END_ARRAY) continue;
                    if (jt == JsonToken.VALUE_NULL) {
                        while (JsonToken.VALUE_NULL == (jt = parser.nextToken())) {
                        }
                        if (jt == JsonToken.END_ARRAY) continue;
                    }
                    int n = number2 = this.numeric ? Integer.parseInt(name) : schema.getFieldNumber(name);
                    if (number2 == 0) {
                        if (parser.getCurrentToken().isScalarValue()) {
                            while (true) {
                                if (parser.nextToken() == JsonToken.END_ARRAY) continue block0;
                            }
                        }
                        throw new JsonInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                    }
                    this.lastRepeated = true;
                    this.lastName = name;
                    this.lastNumber = number2;
                    return number2;
                }
                if (parser.getCurrentToken() == JsonToken.VALUE_NULL) continue;
                int n = number = this.numeric ? Integer.parseInt(name) : schema.getFieldNumber(name);
                if (number != 0) break block9;
                if (!parser.getCurrentToken().isScalarValue()) break;
            }
            throw new JsonInputException("Unknown field: " + name + " on message " + schema.messageFullName());
        }
        this.lastName = name;
        this.lastNumber = number;
        return number;
    }

    public boolean readBool() throws IOException {
        JsonToken jt = this.parser.getCurrentToken();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        if (jt == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jt == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonInputException("Expected token: true/false but was " + jt);
    }

    public byte[] readByteArray() throws IOException {
        byte[] value = this.parser.getBinaryValue();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    public double readDouble() throws IOException {
        double value = this.parser.getDoubleValue();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public int readEnum() throws IOException {
        return this.readInt32();
    }

    public int readFixed32() throws IOException {
        return this.readInt32();
    }

    public long readFixed64() throws IOException {
        return this.readInt64();
    }

    public float readFloat() throws IOException {
        float value = this.parser.getFloatValue();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public int readInt32() throws IOException {
        int value = this.parser.getIntValue();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public long readInt64() throws IOException {
        long value = this.parser.getLongValue();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public int readSFixed32() throws IOException {
        return this.readInt32();
    }

    public long readSFixed64() throws IOException {
        return this.readInt64();
    }

    public int readSInt32() throws IOException {
        return this.readInt32();
    }

    public long readSInt64() throws IOException {
        return this.readInt64();
    }

    public String readString() throws IOException {
        if (this.parser.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw new JsonInputException("Expected token: string but was " + this.parser.getCurrentToken());
        }
        String value = this.parser.getText();
        if (this.lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public int readUInt32() throws IOException {
        return this.readInt32();
    }

    public long readUInt64() throws IOException {
        return this.readInt64();
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonInputException("Expected token: { but was " + this.parser.getCurrentToken() + " on " + this.lastName + " of message " + schema.messageFullName());
        }
        int lastNumber = this.lastNumber;
        boolean lastRepeated = this.lastRepeated;
        String lastName = this.lastName;
        this.lastRepeated = false;
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonInputException("Expected token: } but was " + this.parser.getCurrentToken() + " on " + lastName + " of message " + schema.messageFullName());
        }
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.lastNumber = lastNumber;
        this.lastRepeated = lastRepeated;
        this.lastName = lastName;
        if (lastRepeated && this.parser.nextToken() == JsonToken.END_ARRAY) {
            this.lastRepeated = false;
        }
        return value;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        if (utf8String) {
            output.writeString(fieldNumber, this.readString(), repeated);
        } else {
            output.writeByteArray(fieldNumber, this.readByteArray(), repeated);
        }
    }
}

